package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainRealTimeBpsData invokes the dcdn.DescribeDcdnDomainRealTimeBpsData API synchronously
func (client *Client) DescribeDcdnDomainRealTimeBpsData(request *DescribeDcdnDomainRealTimeBpsDataRequest) (response *DescribeDcdnDomainRealTimeBpsDataResponse, err error) {
	response = CreateDescribeDcdnDomainRealTimeBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainRealTimeBpsDataWithChan invokes the dcdn.DescribeDcdnDomainRealTimeBpsData API asynchronously
func (client *Client) DescribeDcdnDomainRealTimeBpsDataWithChan(request *DescribeDcdnDomainRealTimeBpsDataRequest) (<-chan *DescribeDcdnDomainRealTimeBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainRealTimeBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainRealTimeBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainRealTimeBpsDataWithCallback invokes the dcdn.DescribeDcdnDomainRealTimeBpsData API asynchronously
func (client *Client) DescribeDcdnDomainRealTimeBpsDataWithCallback(request *DescribeDcdnDomainRealTimeBpsDataRequest, callback func(response *DescribeDcdnDomainRealTimeBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainRealTimeBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainRealTimeBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainRealTimeBpsDataRequest is the request struct for api DescribeDcdnDomainRealTimeBpsData
type DescribeDcdnDomainRealTimeBpsDataRequest struct {
	*requests.RpcRequest
	DomainName     string `position:"Query" name:"DomainName"`
	EndTime        string `position:"Query" name:"EndTime"`
	LocationNameEn string `position:"Query" name:"LocationNameEn"`
	IspNameEn      string `position:"Query" name:"IspNameEn"`
	StartTime      string `position:"Query" name:"StartTime"`
}

// DescribeDcdnDomainRealTimeBpsDataResponse is the response struct for api DescribeDcdnDomainRealTimeBpsData
type DescribeDcdnDomainRealTimeBpsDataResponse struct {
	*responses.BaseResponse
	RequestId string                                  `json:"RequestId" xml:"RequestId"`
	Data      DataInDescribeDcdnDomainRealTimeBpsData `json:"Data" xml:"Data"`
}

// CreateDescribeDcdnDomainRealTimeBpsDataRequest creates a request to invoke DescribeDcdnDomainRealTimeBpsData API
func CreateDescribeDcdnDomainRealTimeBpsDataRequest() (request *DescribeDcdnDomainRealTimeBpsDataRequest) {
	request = &DescribeDcdnDomainRealTimeBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainRealTimeBpsData", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDcdnDomainRealTimeBpsDataResponse creates a response to parse from DescribeDcdnDomainRealTimeBpsData response
func CreateDescribeDcdnDomainRealTimeBpsDataResponse() (response *DescribeDcdnDomainRealTimeBpsDataResponse) {
	response = &DescribeDcdnDomainRealTimeBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
