package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunTriggerNode invokes the dataworks_public.RunTriggerNode API synchronously
func (client *Client) RunTriggerNode(request *RunTriggerNodeRequest) (response *RunTriggerNodeResponse, err error) {
	response = CreateRunTriggerNodeResponse()
	err = client.DoAction(request, response)
	return
}

// RunTriggerNodeWithChan invokes the dataworks_public.RunTriggerNode API asynchronously
func (client *Client) RunTriggerNodeWithChan(request *RunTriggerNodeRequest) (<-chan *RunTriggerNodeResponse, <-chan error) {
	responseChan := make(chan *RunTriggerNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunTriggerNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunTriggerNodeWithCallback invokes the dataworks_public.RunTriggerNode API asynchronously
func (client *Client) RunTriggerNodeWithCallback(request *RunTriggerNodeRequest, callback func(response *RunTriggerNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunTriggerNodeResponse
		var err error
		defer close(result)
		response, err = client.RunTriggerNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunTriggerNodeRequest is the request struct for api RunTriggerNode
type RunTriggerNodeRequest struct {
	*requests.RpcRequest
	BizDate   requests.Integer `position:"Body" name:"BizDate"`
	AppId     requests.Integer `position:"Body" name:"AppId"`
	CycleTime requests.Integer `position:"Body" name:"CycleTime"`
	NodeId    requests.Integer `position:"Body" name:"NodeId"`
}

// RunTriggerNodeResponse is the response struct for api RunTriggerNode
type RunTriggerNodeResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRunTriggerNodeRequest creates a request to invoke RunTriggerNode API
func CreateRunTriggerNodeRequest() (request *RunTriggerNodeRequest) {
	request = &RunTriggerNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "RunTriggerNode", "", "")
	request.Method = requests.POST
	return
}

// CreateRunTriggerNodeResponse creates a response to parse from RunTriggerNode response
func CreateRunTriggerNodeResponse() (response *RunTriggerNodeResponse) {
	response = &RunTriggerNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
