package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListShiftPersonnels invokes the dataworks_public.ListShiftPersonnels API synchronously
func (client *Client) ListShiftPersonnels(request *ListShiftPersonnelsRequest) (response *ListShiftPersonnelsResponse, err error) {
	response = CreateListShiftPersonnelsResponse()
	err = client.DoAction(request, response)
	return
}

// ListShiftPersonnelsWithChan invokes the dataworks_public.ListShiftPersonnels API asynchronously
func (client *Client) ListShiftPersonnelsWithChan(request *ListShiftPersonnelsRequest) (<-chan *ListShiftPersonnelsResponse, <-chan error) {
	responseChan := make(chan *ListShiftPersonnelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListShiftPersonnels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListShiftPersonnelsWithCallback invokes the dataworks_public.ListShiftPersonnels API asynchronously
func (client *Client) ListShiftPersonnelsWithCallback(request *ListShiftPersonnelsRequest, callback func(response *ListShiftPersonnelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListShiftPersonnelsResponse
		var err error
		defer close(result)
		response, err = client.ListShiftPersonnels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListShiftPersonnelsRequest is the request struct for api ListShiftPersonnels
type ListShiftPersonnelsRequest struct {
	*requests.RpcRequest
	ShiftPersonUID          string           `position:"Body" name:"ShiftPersonUID"`
	UserType                string           `position:"Body" name:"UserType"`
	EndTime                 requests.Integer `position:"Body" name:"EndTime"`
	BeginTime               requests.Integer `position:"Body" name:"BeginTime"`
	ShiftScheduleIdentifier string           `position:"Body" name:"ShiftScheduleIdentifier"`
}

// ListShiftPersonnelsResponse is the response struct for api ListShiftPersonnels
type ListShiftPersonnelsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Paging    Paging `json:"Paging" xml:"Paging"`
}

// CreateListShiftPersonnelsRequest creates a request to invoke ListShiftPersonnels API
func CreateListShiftPersonnelsRequest() (request *ListShiftPersonnelsRequest) {
	request = &ListShiftPersonnelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListShiftPersonnels", "", "")
	request.Method = requests.POST
	return
}

// CreateListShiftPersonnelsResponse creates a response to parse from ListShiftPersonnels response
func CreateListShiftPersonnelsResponse() (response *ListShiftPersonnelsResponse) {
	response = &ListShiftPersonnelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
