package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLineage invokes the dataworks_public.ListLineage API synchronously
func (client *Client) ListLineage(request *ListLineageRequest) (response *ListLineageResponse, err error) {
	response = CreateListLineageResponse()
	err = client.DoAction(request, response)
	return
}

// ListLineageWithChan invokes the dataworks_public.ListLineage API asynchronously
func (client *Client) ListLineageWithChan(request *ListLineageRequest) (<-chan *ListLineageResponse, <-chan error) {
	responseChan := make(chan *ListLineageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLineage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLineageWithCallback invokes the dataworks_public.ListLineage API asynchronously
func (client *Client) ListLineageWithCallback(request *ListLineageRequest, callback func(response *ListLineageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLineageResponse
		var err error
		defer close(result)
		response, err = client.ListLineage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLineageRequest is the request struct for api ListLineage
type ListLineageRequest struct {
	*requests.RpcRequest
	EntityQualifiedName string           `position:"Query" name:"EntityQualifiedName"`
	NextToken           string           `position:"Query" name:"NextToken"`
	PageSize            requests.Integer `position:"Query" name:"PageSize"`
	Keyword             string           `position:"Query" name:"Keyword"`
	Direction           string           `position:"Query" name:"Direction"`
}

// ListLineageResponse is the response struct for api ListLineage
type ListLineageResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateListLineageRequest creates a request to invoke ListLineage API
func CreateListLineageRequest() (request *ListLineageRequest) {
	request = &ListLineageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListLineage", "", "")
	request.Method = requests.POST
	return
}

// CreateListLineageResponse creates a response to parse from ListLineage response
func CreateListLineageResponse() (response *ListLineageResponse) {
	response = &ListLineageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
