package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstanceHistory invokes the dataworks_public.ListInstanceHistory API synchronously
func (client *Client) ListInstanceHistory(request *ListInstanceHistoryRequest) (response *ListInstanceHistoryResponse, err error) {
	response = CreateListInstanceHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceHistoryWithChan invokes the dataworks_public.ListInstanceHistory API asynchronously
func (client *Client) ListInstanceHistoryWithChan(request *ListInstanceHistoryRequest) (<-chan *ListInstanceHistoryResponse, <-chan error) {
	responseChan := make(chan *ListInstanceHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstanceHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceHistoryWithCallback invokes the dataworks_public.ListInstanceHistory API asynchronously
func (client *Client) ListInstanceHistoryWithCallback(request *ListInstanceHistoryRequest, callback func(response *ListInstanceHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceHistoryResponse
		var err error
		defer close(result)
		response, err = client.ListInstanceHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceHistoryRequest is the request struct for api ListInstanceHistory
type ListInstanceHistoryRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	InstanceId requests.Integer `position:"Body" name:"InstanceId"`
}

// ListInstanceHistoryResponse is the response struct for api ListInstanceHistory
type ListInstanceHistoryResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	Success   bool            `json:"Success" xml:"Success"`
	Instances []InstancesItem `json:"Instances" xml:"Instances"`
}

// CreateListInstanceHistoryRequest creates a request to invoke ListInstanceHistory API
func CreateListInstanceHistoryRequest() (request *ListInstanceHistoryRequest) {
	request = &ListInstanceHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListInstanceHistory", "", "")
	request.Method = requests.POST
	return
}

// CreateListInstanceHistoryResponse creates a response to parse from ListInstanceHistory response
func CreateListInstanceHistoryResponse() (response *ListInstanceHistoryResponse) {
	response = &ListInstanceHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
