package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetExtension invokes the dataworks_public.GetExtension API synchronously
func (client *Client) GetExtension(request *GetExtensionRequest) (response *GetExtensionResponse, err error) {
	response = CreateGetExtensionResponse()
	err = client.DoAction(request, response)
	return
}

// GetExtensionWithChan invokes the dataworks_public.GetExtension API asynchronously
func (client *Client) GetExtensionWithChan(request *GetExtensionRequest) (<-chan *GetExtensionResponse, <-chan error) {
	responseChan := make(chan *GetExtensionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetExtension(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetExtensionWithCallback invokes the dataworks_public.GetExtension API asynchronously
func (client *Client) GetExtensionWithCallback(request *GetExtensionRequest, callback func(response *GetExtensionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetExtensionResponse
		var err error
		defer close(result)
		response, err = client.GetExtension(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetExtensionRequest is the request struct for api GetExtension
type GetExtensionRequest struct {
	*requests.RpcRequest
	ExtensionCode string `position:"Query" name:"ExtensionCode"`
}

// GetExtensionResponse is the response struct for api GetExtension
type GetExtensionResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Extension Extension `json:"Extension" xml:"Extension"`
}

// CreateGetExtensionRequest creates a request to invoke GetExtension API
func CreateGetExtensionRequest() (request *GetExtensionRequest) {
	request = &GetExtensionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetExtension", "", "")
	request.Method = requests.POST
	return
}

// CreateGetExtensionResponse creates a response to parse from GetExtension response
func CreateGetExtensionResponse() (response *GetExtensionResponse) {
	response = &GetExtensionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
