package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBaselineStatus invokes the dataworks_public.GetBaselineStatus API synchronously
func (client *Client) GetBaselineStatus(request *GetBaselineStatusRequest) (response *GetBaselineStatusResponse, err error) {
	response = CreateGetBaselineStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetBaselineStatusWithChan invokes the dataworks_public.GetBaselineStatus API asynchronously
func (client *Client) GetBaselineStatusWithChan(request *GetBaselineStatusRequest) (<-chan *GetBaselineStatusResponse, <-chan error) {
	responseChan := make(chan *GetBaselineStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBaselineStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBaselineStatusWithCallback invokes the dataworks_public.GetBaselineStatus API asynchronously
func (client *Client) GetBaselineStatusWithCallback(request *GetBaselineStatusRequest, callback func(response *GetBaselineStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBaselineStatusResponse
		var err error
		defer close(result)
		response, err = client.GetBaselineStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBaselineStatusRequest is the request struct for api GetBaselineStatus
type GetBaselineStatusRequest struct {
	*requests.RpcRequest
	Bizdate    string           `position:"Body" name:"Bizdate"`
	InGroupId  requests.Integer `position:"Body" name:"InGroupId"`
	BaselineId requests.Integer `position:"Body" name:"BaselineId"`
}

// GetBaselineStatusResponse is the response struct for api GetBaselineStatus
type GetBaselineStatusResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetBaselineStatusRequest creates a request to invoke GetBaselineStatus API
func CreateGetBaselineStatusRequest() (request *GetBaselineStatusRequest) {
	request = &GetBaselineStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetBaselineStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateGetBaselineStatusResponse creates a response to parse from GetBaselineStatus response
func CreateGetBaselineStatusResponse() (response *GetBaselineStatusResponse) {
	response = &GetBaselineStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
