package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgScenedDeleteScene invokes the dataworks_public.DsgScenedDeleteScene API synchronously
func (client *Client) DsgScenedDeleteScene(request *DsgScenedDeleteSceneRequest) (response *DsgScenedDeleteSceneResponse, err error) {
	response = CreateDsgScenedDeleteSceneResponse()
	err = client.DoAction(request, response)
	return
}

// DsgScenedDeleteSceneWithChan invokes the dataworks_public.DsgScenedDeleteScene API asynchronously
func (client *Client) DsgScenedDeleteSceneWithChan(request *DsgScenedDeleteSceneRequest) (<-chan *DsgScenedDeleteSceneResponse, <-chan error) {
	responseChan := make(chan *DsgScenedDeleteSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgScenedDeleteScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgScenedDeleteSceneWithCallback invokes the dataworks_public.DsgScenedDeleteScene API asynchronously
func (client *Client) DsgScenedDeleteSceneWithCallback(request *DsgScenedDeleteSceneRequest, callback func(response *DsgScenedDeleteSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgScenedDeleteSceneResponse
		var err error
		defer close(result)
		response, err = client.DsgScenedDeleteScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgScenedDeleteSceneRequest is the request struct for api DsgScenedDeleteScene
type DsgScenedDeleteSceneRequest struct {
	*requests.RpcRequest
	Ids *[]string `position:"Query" name:"Ids"  type:"Json"`
}

// DsgScenedDeleteSceneResponse is the response struct for api DsgScenedDeleteScene
type DsgScenedDeleteSceneResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateDsgScenedDeleteSceneRequest creates a request to invoke DsgScenedDeleteScene API
func CreateDsgScenedDeleteSceneRequest() (request *DsgScenedDeleteSceneRequest) {
	request = &DsgScenedDeleteSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgScenedDeleteScene", "", "")
	request.Method = requests.POST
	return
}

// CreateDsgScenedDeleteSceneResponse creates a response to parse from DsgScenedDeleteScene response
func CreateDsgScenedDeleteSceneResponse() (response *DsgScenedDeleteSceneResponse) {
	response = &DsgScenedDeleteSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
