package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMetaCollection invokes the dataworks_public.CreateMetaCollection API synchronously
func (client *Client) CreateMetaCollection(request *CreateMetaCollectionRequest) (response *CreateMetaCollectionResponse, err error) {
	response = CreateCreateMetaCollectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMetaCollectionWithChan invokes the dataworks_public.CreateMetaCollection API asynchronously
func (client *Client) CreateMetaCollectionWithChan(request *CreateMetaCollectionRequest) (<-chan *CreateMetaCollectionResponse, <-chan error) {
	responseChan := make(chan *CreateMetaCollectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMetaCollection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMetaCollectionWithCallback invokes the dataworks_public.CreateMetaCollection API asynchronously
func (client *Client) CreateMetaCollectionWithCallback(request *CreateMetaCollectionRequest, callback func(response *CreateMetaCollectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMetaCollectionResponse
		var err error
		defer close(result)
		response, err = client.CreateMetaCollection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMetaCollectionRequest is the request struct for api CreateMetaCollection
type CreateMetaCollectionRequest struct {
	*requests.RpcRequest
	ParentQualifiedName string `position:"Query" name:"ParentQualifiedName"`
	CollectionType      string `position:"Query" name:"CollectionType"`
	Name                string `position:"Query" name:"Name"`
	Comment             string `position:"Query" name:"Comment"`
}

// CreateMetaCollectionResponse is the response struct for api CreateMetaCollection
type CreateMetaCollectionResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	QualifiedName  string `json:"QualifiedName" xml:"QualifiedName"`
	Success        string `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateMetaCollectionRequest creates a request to invoke CreateMetaCollection API
func CreateCreateMetaCollectionRequest() (request *CreateMetaCollectionRequest) {
	request = &CreateMetaCollectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateMetaCollection", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMetaCollectionResponse creates a response to parse from CreateMetaCollection response
func CreateCreateMetaCollectionResponse() (response *CreateMetaCollectionResponse) {
	response = &CreateMetaCollectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
