package cusanalytic_sc_online

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOverviewData invokes the cusanalytic_sc_online.GetOverviewData API synchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getoverviewdata.html
func (client *Client) GetOverviewData(request *GetOverviewDataRequest) (response *GetOverviewDataResponse, err error) {
	response = CreateGetOverviewDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetOverviewDataWithChan invokes the cusanalytic_sc_online.GetOverviewData API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getoverviewdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOverviewDataWithChan(request *GetOverviewDataRequest) (<-chan *GetOverviewDataResponse, <-chan error) {
	responseChan := make(chan *GetOverviewDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOverviewData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOverviewDataWithCallback invokes the cusanalytic_sc_online.GetOverviewData API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getoverviewdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOverviewDataWithCallback(request *GetOverviewDataRequest, callback func(response *GetOverviewDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOverviewDataResponse
		var err error
		defer close(result)
		response, err = client.GetOverviewData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOverviewDataRequest is the request struct for api GetOverviewData
type GetOverviewDataRequest struct {
	*requests.RpcRequest
	Date     string `position:"Body" name:"Date"`
	StoreIds string `position:"Body" name:"StoreIds"`
}

// GetOverviewDataResponse is the response struct for api GetOverviewData
type GetOverviewDataResponse struct {
	*responses.BaseResponse
	StayDeepAvg                    float64 `json:"StayDeepAvg" xml:"StayDeepAvg"`
	UvWeekGrowthPercent            float64 `json:"UvWeekGrowthPercent" xml:"UvWeekGrowthPercent"`
	StayDeepAvgWeekGrowthPercent   float64 `json:"StayDeepAvgWeekGrowthPercent" xml:"StayDeepAvgWeekGrowthPercent"`
	Uv                             int64   `json:"Uv" xml:"Uv"`
	StayAvgPeriodWeekGrowthPercent float64 `json:"StayAvgPeriodWeekGrowthPercent" xml:"StayAvgPeriodWeekGrowthPercent"`
	UvEverySqm                     float64 `json:"UvEverySqm" xml:"UvEverySqm"`
	UvAvgWeekGrowthPercent         float64 `json:"UvAvgWeekGrowthPercent" xml:"UvAvgWeekGrowthPercent"`
	StayAvgPeriod                  float64 `json:"StayAvgPeriod" xml:"StayAvgPeriod"`
	UvAvg                          float64 `json:"UvAvg" xml:"UvAvg"`
	UvEverySqmGrowthWeekPercent    float64 `json:"UvEverySqmGrowthWeekPercent" xml:"UvEverySqmGrowthWeekPercent"`
}

// CreateGetOverviewDataRequest creates a request to invoke GetOverviewData API
func CreateGetOverviewDataRequest() (request *GetOverviewDataRequest) {
	request = &GetOverviewDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cusanalytic_sc_online", "2019-05-24", "GetOverviewData", "", "")
	return
}

// CreateGetOverviewDataResponse creates a response to parse from GetOverviewData response
func CreateGetOverviewDataResponse() (response *GetOverviewDataResponse) {
	response = &GetOverviewDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
