package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRegistrationPolicy invokes the csas.UpdateRegistrationPolicy API synchronously
func (client *Client) UpdateRegistrationPolicy(request *UpdateRegistrationPolicyRequest) (response *UpdateRegistrationPolicyResponse, err error) {
	response = CreateUpdateRegistrationPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRegistrationPolicyWithChan invokes the csas.UpdateRegistrationPolicy API asynchronously
func (client *Client) UpdateRegistrationPolicyWithChan(request *UpdateRegistrationPolicyRequest) (<-chan *UpdateRegistrationPolicyResponse, <-chan error) {
	responseChan := make(chan *UpdateRegistrationPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRegistrationPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRegistrationPolicyWithCallback invokes the csas.UpdateRegistrationPolicy API asynchronously
func (client *Client) UpdateRegistrationPolicyWithCallback(request *UpdateRegistrationPolicyRequest, callback func(response *UpdateRegistrationPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRegistrationPolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdateRegistrationPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRegistrationPolicyRequest is the request struct for api UpdateRegistrationPolicy
type UpdateRegistrationPolicyRequest struct {
	*requests.RpcRequest
	Description        string                                     `position:"Body" name:"Description"`
	MatchMode          string                                     `position:"Body" name:"MatchMode"`
	SourceIp           string                                     `position:"Query" name:"SourceIp"`
	PolicyId           string                                     `position:"Body" name:"PolicyId"`
	CompanyLimitCount  UpdateRegistrationPolicyCompanyLimitCount  `position:"Body" name:"CompanyLimitCount"  type:"Struct"`
	PersonalLimitCount UpdateRegistrationPolicyPersonalLimitCount `position:"Body" name:"PersonalLimitCount"  type:"Struct"`
	UserGroupIds       *[]string                                  `position:"Body" name:"UserGroupIds"  type:"Repeated"`
	Whitelist          *[]string                                  `position:"Body" name:"Whitelist"  type:"Repeated"`
	Priority           requests.Integer                           `position:"Body" name:"Priority"`
	PersonalLimitType  string                                     `position:"Body" name:"PersonalLimitType"`
	Name               string                                     `position:"Body" name:"Name"`
	CompanyLimitType   string                                     `position:"Body" name:"CompanyLimitType"`
	Status             string                                     `position:"Body" name:"Status"`
}

// UpdateRegistrationPolicyCompanyLimitCount is a repeated param struct in UpdateRegistrationPolicyRequest
type UpdateRegistrationPolicyCompanyLimitCount struct {
	All    string `name:"All"`
	PC     string `name:"PC"`
	Mobile string `name:"Mobile"`
}

// UpdateRegistrationPolicyPersonalLimitCount is a repeated param struct in UpdateRegistrationPolicyRequest
type UpdateRegistrationPolicyPersonalLimitCount struct {
	All    string `name:"All"`
	PC     string `name:"PC"`
	Mobile string `name:"Mobile"`
}

// UpdateRegistrationPolicyResponse is the response struct for api UpdateRegistrationPolicy
type UpdateRegistrationPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Policy    Policy `json:"Policy" xml:"Policy"`
}

// CreateUpdateRegistrationPolicyRequest creates a request to invoke UpdateRegistrationPolicy API
func CreateUpdateRegistrationPolicyRequest() (request *UpdateRegistrationPolicyRequest) {
	request = &UpdateRegistrationPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateRegistrationPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateRegistrationPolicyResponse creates a response to parse from UpdateRegistrationPolicy response
func CreateUpdateRegistrationPolicyResponse() (response *UpdateRegistrationPolicyResponse) {
	response = &UpdateRegistrationPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
