package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateApprovalStatus invokes the csas.UpdateApprovalStatus API synchronously
func (client *Client) UpdateApprovalStatus(request *UpdateApprovalStatusRequest) (response *UpdateApprovalStatusResponse, err error) {
	response = CreateUpdateApprovalStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateApprovalStatusWithChan invokes the csas.UpdateApprovalStatus API asynchronously
func (client *Client) UpdateApprovalStatusWithChan(request *UpdateApprovalStatusRequest) (<-chan *UpdateApprovalStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateApprovalStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateApprovalStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateApprovalStatusWithCallback invokes the csas.UpdateApprovalStatus API asynchronously
func (client *Client) UpdateApprovalStatusWithCallback(request *UpdateApprovalStatusRequest, callback func(response *UpdateApprovalStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateApprovalStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateApprovalStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateApprovalStatusRequest is the request struct for api UpdateApprovalStatus
type UpdateApprovalStatusRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	ApprovalId string `position:"Query" name:"ApprovalId"`
	Status     string `position:"Query" name:"Status"`
}

// UpdateApprovalStatusResponse is the response struct for api UpdateApprovalStatus
type UpdateApprovalStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Approval  []Data `json:"Approval" xml:"Approval"`
}

// CreateUpdateApprovalStatusRequest creates a request to invoke UpdateApprovalStatus API
func CreateUpdateApprovalStatusRequest() (request *UpdateApprovalStatusRequest) {
	request = &UpdateApprovalStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateApprovalStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateApprovalStatusResponse creates a response to parse from UpdateApprovalStatus response
func CreateUpdateApprovalStatusResponse() (response *UpdateApprovalStatusResponse) {
	response = &UpdateApprovalStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
