package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPopTrafficStatistics invokes the csas.ListPopTrafficStatistics API synchronously
func (client *Client) ListPopTrafficStatistics(request *ListPopTrafficStatisticsRequest) (response *ListPopTrafficStatisticsResponse, err error) {
	response = CreateListPopTrafficStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPopTrafficStatisticsWithChan invokes the csas.ListPopTrafficStatistics API asynchronously
func (client *Client) ListPopTrafficStatisticsWithChan(request *ListPopTrafficStatisticsRequest) (<-chan *ListPopTrafficStatisticsResponse, <-chan error) {
	responseChan := make(chan *ListPopTrafficStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPopTrafficStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPopTrafficStatisticsWithCallback invokes the csas.ListPopTrafficStatistics API asynchronously
func (client *Client) ListPopTrafficStatisticsWithCallback(request *ListPopTrafficStatisticsRequest, callback func(response *ListPopTrafficStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPopTrafficStatisticsResponse
		var err error
		defer close(result)
		response, err = client.ListPopTrafficStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPopTrafficStatisticsRequest is the request struct for api ListPopTrafficStatistics
type ListPopTrafficStatisticsRequest struct {
	*requests.RpcRequest
	EndTime   string `position:"Query" name:"EndTime"`
	StartTime string `position:"Query" name:"StartTime"`
	Region    string `position:"Query" name:"Region"`
}

// ListPopTrafficStatisticsResponse is the response struct for api ListPopTrafficStatistics
type ListPopTrafficStatisticsResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	TrafficData []Data `json:"TrafficData" xml:"TrafficData"`
}

// CreateListPopTrafficStatisticsRequest creates a request to invoke ListPopTrafficStatistics API
func CreateListPopTrafficStatisticsRequest() (request *ListPopTrafficStatisticsRequest) {
	request = &ListPopTrafficStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListPopTrafficStatistics", "", "")
	request.Method = requests.GET
	return
}

// CreateListPopTrafficStatisticsResponse creates a response to parse from ListPopTrafficStatistics response
func CreateListPopTrafficStatisticsResponse() (response *ListPopTrafficStatisticsResponse) {
	response = &ListPopTrafficStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
