package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetActiveIdpConfig invokes the csas.GetActiveIdpConfig API synchronously
func (client *Client) GetActiveIdpConfig(request *GetActiveIdpConfigRequest) (response *GetActiveIdpConfigResponse, err error) {
	response = CreateGetActiveIdpConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetActiveIdpConfigWithChan invokes the csas.GetActiveIdpConfig API asynchronously
func (client *Client) GetActiveIdpConfigWithChan(request *GetActiveIdpConfigRequest) (<-chan *GetActiveIdpConfigResponse, <-chan error) {
	responseChan := make(chan *GetActiveIdpConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetActiveIdpConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetActiveIdpConfigWithCallback invokes the csas.GetActiveIdpConfig API asynchronously
func (client *Client) GetActiveIdpConfigWithCallback(request *GetActiveIdpConfigRequest, callback func(response *GetActiveIdpConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetActiveIdpConfigResponse
		var err error
		defer close(result)
		response, err = client.GetActiveIdpConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetActiveIdpConfigRequest is the request struct for api GetActiveIdpConfig
type GetActiveIdpConfigRequest struct {
	*requests.RpcRequest
}

// GetActiveIdpConfigResponse is the response struct for api GetActiveIdpConfig
type GetActiveIdpConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetActiveIdpConfigRequest creates a request to invoke GetActiveIdpConfig API
func CreateGetActiveIdpConfigRequest() (request *GetActiveIdpConfigRequest) {
	request = &GetActiveIdpConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetActiveIdpConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateGetActiveIdpConfigResponse creates a response to parse from GetActiveIdpConfig response
func CreateGetActiveIdpConfigResponse() (response *GetActiveIdpConfigResponse) {
	response = &GetActiveIdpConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
