package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePrivateAccessPolicy invokes the csas.DeletePrivateAccessPolicy API synchronously
func (client *Client) DeletePrivateAccessPolicy(request *DeletePrivateAccessPolicyRequest) (response *DeletePrivateAccessPolicyResponse, err error) {
	response = CreateDeletePrivateAccessPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePrivateAccessPolicyWithChan invokes the csas.DeletePrivateAccessPolicy API asynchronously
func (client *Client) DeletePrivateAccessPolicyWithChan(request *DeletePrivateAccessPolicyRequest) (<-chan *DeletePrivateAccessPolicyResponse, <-chan error) {
	responseChan := make(chan *DeletePrivateAccessPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePrivateAccessPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePrivateAccessPolicyWithCallback invokes the csas.DeletePrivateAccessPolicy API asynchronously
func (client *Client) DeletePrivateAccessPolicyWithCallback(request *DeletePrivateAccessPolicyRequest, callback func(response *DeletePrivateAccessPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePrivateAccessPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeletePrivateAccessPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePrivateAccessPolicyRequest is the request struct for api DeletePrivateAccessPolicy
type DeletePrivateAccessPolicyRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	PolicyId string `position:"Body" name:"PolicyId"`
}

// DeletePrivateAccessPolicyResponse is the response struct for api DeletePrivateAccessPolicy
type DeletePrivateAccessPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePrivateAccessPolicyRequest creates a request to invoke DeletePrivateAccessPolicy API
func CreateDeletePrivateAccessPolicyRequest() (request *DeletePrivateAccessPolicyRequest) {
	request = &DeletePrivateAccessPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "DeletePrivateAccessPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateDeletePrivateAccessPolicyResponse creates a response to parse from DeletePrivateAccessPolicy response
func CreateDeletePrivateAccessPolicyResponse() (response *DeletePrivateAccessPolicyResponse) {
	response = &DeletePrivateAccessPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
