package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartConfigurationRecorder invokes the config.StartConfigurationRecorder API synchronously
func (client *Client) StartConfigurationRecorder(request *StartConfigurationRecorderRequest) (response *StartConfigurationRecorderResponse, err error) {
	response = CreateStartConfigurationRecorderResponse()
	err = client.DoAction(request, response)
	return
}

// StartConfigurationRecorderWithChan invokes the config.StartConfigurationRecorder API asynchronously
func (client *Client) StartConfigurationRecorderWithChan(request *StartConfigurationRecorderRequest) (<-chan *StartConfigurationRecorderResponse, <-chan error) {
	responseChan := make(chan *StartConfigurationRecorderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartConfigurationRecorder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartConfigurationRecorderWithCallback invokes the config.StartConfigurationRecorder API asynchronously
func (client *Client) StartConfigurationRecorderWithCallback(request *StartConfigurationRecorderRequest, callback func(response *StartConfigurationRecorderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartConfigurationRecorderResponse
		var err error
		defer close(result)
		response, err = client.StartConfigurationRecorder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartConfigurationRecorderRequest is the request struct for api StartConfigurationRecorder
type StartConfigurationRecorderRequest struct {
	*requests.RpcRequest
}

// StartConfigurationRecorderResponse is the response struct for api StartConfigurationRecorder
type StartConfigurationRecorderResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	ConfigurationRecorder ConfigurationRecorder `json:"ConfigurationRecorder" xml:"ConfigurationRecorder"`
}

// CreateStartConfigurationRecorderRequest creates a request to invoke StartConfigurationRecorder API
func CreateStartConfigurationRecorderRequest() (request *StartConfigurationRecorderRequest) {
	request = &StartConfigurationRecorderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "StartConfigurationRecorder", "", "")
	request.Method = requests.POST
	return
}

// CreateStartConfigurationRecorderResponse creates a response to parse from StartConfigurationRecorder response
func CreateStartConfigurationRecorderResponse() (response *StartConfigurationRecorderResponse) {
	response = &StartConfigurationRecorderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
