package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIntegratedService invokes the config.ListIntegratedService API synchronously
func (client *Client) ListIntegratedService(request *ListIntegratedServiceRequest) (response *ListIntegratedServiceResponse, err error) {
	response = CreateListIntegratedServiceResponse()
	err = client.DoAction(request, response)
	return
}

// ListIntegratedServiceWithChan invokes the config.ListIntegratedService API asynchronously
func (client *Client) ListIntegratedServiceWithChan(request *ListIntegratedServiceRequest) (<-chan *ListIntegratedServiceResponse, <-chan error) {
	responseChan := make(chan *ListIntegratedServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIntegratedService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIntegratedServiceWithCallback invokes the config.ListIntegratedService API asynchronously
func (client *Client) ListIntegratedServiceWithCallback(request *ListIntegratedServiceRequest, callback func(response *ListIntegratedServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIntegratedServiceResponse
		var err error
		defer close(result)
		response, err = client.ListIntegratedService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIntegratedServiceRequest is the request struct for api ListIntegratedService
type ListIntegratedServiceRequest struct {
	*requests.RpcRequest
}

// ListIntegratedServiceResponse is the response struct for api ListIntegratedService
type ListIntegratedServiceResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListIntegratedServiceRequest creates a request to invoke ListIntegratedService API
func CreateListIntegratedServiceRequest() (request *ListIntegratedServiceRequest) {
	request = &ListIntegratedServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListIntegratedService", "", "")
	request.Method = requests.POST
	return
}

// CreateListIntegratedServiceResponse creates a response to parse from ListIntegratedService response
func CreateListIntegratedServiceResponse() (response *ListIntegratedServiceResponse) {
	response = &ListIntegratedServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
