package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// IgnoreEvaluationResults invokes the config.IgnoreEvaluationResults API synchronously
func (client *Client) IgnoreEvaluationResults(request *IgnoreEvaluationResultsRequest) (response *IgnoreEvaluationResultsResponse, err error) {
	response = CreateIgnoreEvaluationResultsResponse()
	err = client.DoAction(request, response)
	return
}

// IgnoreEvaluationResultsWithChan invokes the config.IgnoreEvaluationResults API asynchronously
func (client *Client) IgnoreEvaluationResultsWithChan(request *IgnoreEvaluationResultsRequest) (<-chan *IgnoreEvaluationResultsResponse, <-chan error) {
	responseChan := make(chan *IgnoreEvaluationResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.IgnoreEvaluationResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// IgnoreEvaluationResultsWithCallback invokes the config.IgnoreEvaluationResults API asynchronously
func (client *Client) IgnoreEvaluationResultsWithCallback(request *IgnoreEvaluationResultsRequest, callback func(response *IgnoreEvaluationResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *IgnoreEvaluationResultsResponse
		var err error
		defer close(result)
		response, err = client.IgnoreEvaluationResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// IgnoreEvaluationResultsRequest is the request struct for api IgnoreEvaluationResults
type IgnoreEvaluationResultsRequest struct {
	*requests.RpcRequest
	ConfigRuleId string                              `position:"Body" name:"ConfigRuleId"`
	Reason       string                              `position:"Body" name:"Reason"`
	IgnoreDate   string                              `position:"Body" name:"IgnoreDate"`
	Resources    *[]IgnoreEvaluationResultsResources `position:"Body" name:"Resources"  type:"Json"`
}

// IgnoreEvaluationResultsResources is a repeated param struct in IgnoreEvaluationResultsRequest
type IgnoreEvaluationResultsResources struct {
	ResourceId        string `name:"ResourceId"`
	ResourceAccountId string `name:"ResourceAccountId"`
	Region            string `name:"Region"`
	ResourceType      string `name:"ResourceType"`
}

// IgnoreEvaluationResultsResponse is the response struct for api IgnoreEvaluationResults
type IgnoreEvaluationResultsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateIgnoreEvaluationResultsRequest creates a request to invoke IgnoreEvaluationResults API
func CreateIgnoreEvaluationResultsRequest() (request *IgnoreEvaluationResultsRequest) {
	request = &IgnoreEvaluationResultsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "IgnoreEvaluationResults", "", "")
	request.Method = requests.POST
	return
}

// CreateIgnoreEvaluationResultsResponse creates a response to parse from IgnoreEvaluationResults response
func CreateIgnoreEvaluationResultsResponse() (response *IgnoreEvaluationResultsResponse) {
	response = &IgnoreEvaluationResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
