package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAdvancedSearchFile invokes the config.CreateAdvancedSearchFile API synchronously
func (client *Client) CreateAdvancedSearchFile(request *CreateAdvancedSearchFileRequest) (response *CreateAdvancedSearchFileResponse, err error) {
	response = CreateCreateAdvancedSearchFileResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAdvancedSearchFileWithChan invokes the config.CreateAdvancedSearchFile API asynchronously
func (client *Client) CreateAdvancedSearchFileWithChan(request *CreateAdvancedSearchFileRequest) (<-chan *CreateAdvancedSearchFileResponse, <-chan error) {
	responseChan := make(chan *CreateAdvancedSearchFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAdvancedSearchFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAdvancedSearchFileWithCallback invokes the config.CreateAdvancedSearchFile API asynchronously
func (client *Client) CreateAdvancedSearchFileWithCallback(request *CreateAdvancedSearchFileRequest, callback func(response *CreateAdvancedSearchFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAdvancedSearchFileResponse
		var err error
		defer close(result)
		response, err = client.CreateAdvancedSearchFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAdvancedSearchFileRequest is the request struct for api CreateAdvancedSearchFile
type CreateAdvancedSearchFileRequest struct {
	*requests.RpcRequest
	Sql          string           `position:"Query" name:"Sql"`
	OnlyBaseLine requests.Boolean `position:"Query" name:"OnlyBaseLine"`
}

// CreateAdvancedSearchFileResponse is the response struct for api CreateAdvancedSearchFile
type CreateAdvancedSearchFileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateAdvancedSearchFileRequest creates a request to invoke CreateAdvancedSearchFile API
func CreateCreateAdvancedSearchFileRequest() (request *CreateAdvancedSearchFileRequest) {
	request = &CreateAdvancedSearchFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "CreateAdvancedSearchFile", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAdvancedSearchFileResponse creates a response to parse from CreateAdvancedSearchFile response
func CreateCreateAdvancedSearchFileResponse() (response *CreateAdvancedSearchFileResponse) {
	response = &CreateAdvancedSearchFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
