package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetArtifactRepositoryCredentials invokes the computenestsupplier.GetArtifactRepositoryCredentials API synchronously
func (client *Client) GetArtifactRepositoryCredentials(request *GetArtifactRepositoryCredentialsRequest) (response *GetArtifactRepositoryCredentialsResponse, err error) {
	response = CreateGetArtifactRepositoryCredentialsResponse()
	err = client.DoAction(request, response)
	return
}

// GetArtifactRepositoryCredentialsWithChan invokes the computenestsupplier.GetArtifactRepositoryCredentials API asynchronously
func (client *Client) GetArtifactRepositoryCredentialsWithChan(request *GetArtifactRepositoryCredentialsRequest) (<-chan *GetArtifactRepositoryCredentialsResponse, <-chan error) {
	responseChan := make(chan *GetArtifactRepositoryCredentialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetArtifactRepositoryCredentials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetArtifactRepositoryCredentialsWithCallback invokes the computenestsupplier.GetArtifactRepositoryCredentials API asynchronously
func (client *Client) GetArtifactRepositoryCredentialsWithCallback(request *GetArtifactRepositoryCredentialsRequest, callback func(response *GetArtifactRepositoryCredentialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetArtifactRepositoryCredentialsResponse
		var err error
		defer close(result)
		response, err = client.GetArtifactRepositoryCredentials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetArtifactRepositoryCredentialsRequest is the request struct for api GetArtifactRepositoryCredentials
type GetArtifactRepositoryCredentialsRequest struct {
	*requests.RpcRequest
	DeployRegionId string `position:"Query" name:"DeployRegionId"`
	ArtifactType   string `position:"Query" name:"ArtifactType"`
}

// GetArtifactRepositoryCredentialsResponse is the response struct for api GetArtifactRepositoryCredentials
type GetArtifactRepositoryCredentialsResponse struct {
	*responses.BaseResponse
	RequestId          string                   `json:"RequestId" xml:"RequestId"`
	ExpireDate         string                   `json:"ExpireDate" xml:"ExpireDate"`
	Credentials        Credentials              `json:"Credentials" xml:"Credentials"`
	AvailableResources []AvailableResourcesItem `json:"AvailableResources" xml:"AvailableResources"`
}

// CreateGetArtifactRepositoryCredentialsRequest creates a request to invoke GetArtifactRepositoryCredentials API
func CreateGetArtifactRepositoryCredentialsRequest() (request *GetArtifactRepositoryCredentialsRequest) {
	request = &GetArtifactRepositoryCredentialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "GetArtifactRepositoryCredentials", "", "")
	request.Method = requests.POST
	return
}

// CreateGetArtifactRepositoryCredentialsResponse creates a response to parse from GetArtifactRepositoryCredentials response
func CreateGetArtifactRepositoryCredentialsResponse() (response *GetArtifactRepositoryCredentialsResponse) {
	response = &GetArtifactRepositoryCredentialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
