package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserDetailSolutions invokes the companyreg.ListUserDetailSolutions API synchronously
func (client *Client) ListUserDetailSolutions(request *ListUserDetailSolutionsRequest) (response *ListUserDetailSolutionsResponse, err error) {
	response = CreateListUserDetailSolutionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserDetailSolutionsWithChan invokes the companyreg.ListUserDetailSolutions API asynchronously
func (client *Client) ListUserDetailSolutionsWithChan(request *ListUserDetailSolutionsRequest) (<-chan *ListUserDetailSolutionsResponse, <-chan error) {
	responseChan := make(chan *ListUserDetailSolutionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserDetailSolutions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserDetailSolutionsWithCallback invokes the companyreg.ListUserDetailSolutions API asynchronously
func (client *Client) ListUserDetailSolutionsWithCallback(request *ListUserDetailSolutionsRequest, callback func(response *ListUserDetailSolutionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserDetailSolutionsResponse
		var err error
		defer close(result)
		response, err = client.ListUserDetailSolutions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserDetailSolutionsRequest is the request struct for api ListUserDetailSolutions
type ListUserDetailSolutionsRequest struct {
	*requests.RpcRequest
	BizType        string           `position:"Query" name:"BizType"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	IntentionBizId string           `position:"Query" name:"IntentionBizId"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
}

// ListUserDetailSolutionsResponse is the response struct for api ListUserDetailSolutions
type ListUserDetailSolutionsResponse struct {
	*responses.BaseResponse
	CurrentPageNum int        `json:"CurrentPageNum" xml:"CurrentPageNum"`
	TotalPageNum   int        `json:"TotalPageNum" xml:"TotalPageNum"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	PageSize       int        `json:"PageSize" xml:"PageSize"`
	TotalItemNum   int        `json:"TotalItemNum" xml:"TotalItemNum"`
	Data           []Solution `json:"Data" xml:"Data"`
}

// CreateListUserDetailSolutionsRequest creates a request to invoke ListUserDetailSolutions API
func CreateListUserDetailSolutionsRequest() (request *ListUserDetailSolutionsRequest) {
	request = &ListUserDetailSolutionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "ListUserDetailSolutions", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListUserDetailSolutionsResponse creates a response to parse from ListUserDetailSolutions response
func CreateListUserDetailSolutionsResponse() (response *ListUserDetailSolutionsResponse) {
	response = &ListUserDetailSolutionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
