package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateUploadFilePolicy invokes the companyreg.GenerateUploadFilePolicy API synchronously
func (client *Client) GenerateUploadFilePolicy(request *GenerateUploadFilePolicyRequest) (response *GenerateUploadFilePolicyResponse, err error) {
	response = CreateGenerateUploadFilePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateUploadFilePolicyWithChan invokes the companyreg.GenerateUploadFilePolicy API asynchronously
func (client *Client) GenerateUploadFilePolicyWithChan(request *GenerateUploadFilePolicyRequest) (<-chan *GenerateUploadFilePolicyResponse, <-chan error) {
	responseChan := make(chan *GenerateUploadFilePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateUploadFilePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateUploadFilePolicyWithCallback invokes the companyreg.GenerateUploadFilePolicy API asynchronously
func (client *Client) GenerateUploadFilePolicyWithCallback(request *GenerateUploadFilePolicyRequest, callback func(response *GenerateUploadFilePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateUploadFilePolicyResponse
		var err error
		defer close(result)
		response, err = client.GenerateUploadFilePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateUploadFilePolicyRequest is the request struct for api GenerateUploadFilePolicy
type GenerateUploadFilePolicyRequest struct {
	*requests.RpcRequest
	FileType string `position:"Query" name:"FileType"`
	BizType  string `position:"Query" name:"BizType"`
	FileName string `position:"Query" name:"FileName"`
}

// GenerateUploadFilePolicyResponse is the response struct for api GenerateUploadFilePolicy
type GenerateUploadFilePolicyResponse struct {
	*responses.BaseResponse
	Signature     string `json:"Signature" xml:"Signature"`
	FileUrl       string `json:"FileUrl" xml:"FileUrl"`
	Host          string `json:"Host" xml:"Host"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ExpireTime    string `json:"ExpireTime" xml:"ExpireTime"`
	EncodedPolicy string `json:"EncodedPolicy" xml:"EncodedPolicy"`
	FileDir       string `json:"FileDir" xml:"FileDir"`
	AccessId      string `json:"AccessId" xml:"AccessId"`
}

// CreateGenerateUploadFilePolicyRequest creates a request to invoke GenerateUploadFilePolicy API
func CreateGenerateUploadFilePolicyRequest() (request *GenerateUploadFilePolicyRequest) {
	request = &GenerateUploadFilePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "GenerateUploadFilePolicy", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateUploadFilePolicyResponse creates a response to parse from GenerateUploadFilePolicy response
func CreateGenerateUploadFilePolicyResponse() (response *GenerateUploadFilePolicyResponse) {
	response = &GenerateUploadFilePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
