package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutCustomMetric invokes the cms.PutCustomMetric API synchronously
func (client *Client) PutCustomMetric(request *PutCustomMetricRequest) (response *PutCustomMetricResponse, err error) {
	response = CreatePutCustomMetricResponse()
	err = client.DoAction(request, response)
	return
}

// PutCustomMetricWithChan invokes the cms.PutCustomMetric API asynchronously
func (client *Client) PutCustomMetricWithChan(request *PutCustomMetricRequest) (<-chan *PutCustomMetricResponse, <-chan error) {
	responseChan := make(chan *PutCustomMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutCustomMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutCustomMetricWithCallback invokes the cms.PutCustomMetric API asynchronously
func (client *Client) PutCustomMetricWithCallback(request *PutCustomMetricRequest, callback func(response *PutCustomMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutCustomMetricResponse
		var err error
		defer close(result)
		response, err = client.PutCustomMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutCustomMetricRequest is the request struct for api PutCustomMetric
type PutCustomMetricRequest struct {
	*requests.RpcRequest
	MetricList *[]PutCustomMetricMetricList `position:"Query" name:"MetricList"  type:"Repeated"`
}

// PutCustomMetricMetricList is a repeated param struct in PutCustomMetricRequest
type PutCustomMetricMetricList struct {
	Period     string `name:"Period"`
	GroupId    string `name:"GroupId"`
	Values     string `name:"Values"`
	Time       string `name:"Time"`
	Type       string `name:"Type"`
	MetricName string `name:"MetricName"`
	Dimensions string `name:"Dimensions"`
}

// PutCustomMetricResponse is the response struct for api PutCustomMetric
type PutCustomMetricResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePutCustomMetricRequest creates a request to invoke PutCustomMetric API
func CreatePutCustomMetricRequest() (request *PutCustomMetricRequest) {
	request = &PutCustomMetricRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "PutCustomMetric", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutCustomMetricResponse creates a response to parse from PutCustomMetric response
func CreatePutCustomMetricResponse() (response *PutCustomMetricResponse) {
	response = &PutCustomMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
