package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyUserIPSWhitelist invokes the cloudfw.ModifyUserIPSWhitelist API synchronously
func (client *Client) ModifyUserIPSWhitelist(request *ModifyUserIPSWhitelistRequest) (response *ModifyUserIPSWhitelistResponse, err error) {
	response = CreateModifyUserIPSWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyUserIPSWhitelistWithChan invokes the cloudfw.ModifyUserIPSWhitelist API asynchronously
func (client *Client) ModifyUserIPSWhitelistWithChan(request *ModifyUserIPSWhitelistRequest) (<-chan *ModifyUserIPSWhitelistResponse, <-chan error) {
	responseChan := make(chan *ModifyUserIPSWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyUserIPSWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyUserIPSWhitelistWithCallback invokes the cloudfw.ModifyUserIPSWhitelist API asynchronously
func (client *Client) ModifyUserIPSWhitelistWithCallback(request *ModifyUserIPSWhitelistRequest, callback func(response *ModifyUserIPSWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyUserIPSWhitelistResponse
		var err error
		defer close(result)
		response, err = client.ModifyUserIPSWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyUserIPSWhitelistRequest is the request struct for api ModifyUserIPSWhitelist
type ModifyUserIPSWhitelistRequest struct {
	*requests.RpcRequest
	WhiteType requests.Integer `position:"Query" name:"WhiteType"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
	ListValue string           `position:"Query" name:"ListValue"`
	ListType  requests.Integer `position:"Query" name:"ListType"`
	IpVersion string           `position:"Query" name:"IpVersion"`
	Lang      string           `position:"Query" name:"Lang"`
	Direction requests.Integer `position:"Query" name:"Direction"`
}

// ModifyUserIPSWhitelistResponse is the response struct for api ModifyUserIPSWhitelist
type ModifyUserIPSWhitelistResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyUserIPSWhitelistRequest creates a request to invoke ModifyUserIPSWhitelist API
func CreateModifyUserIPSWhitelistRequest() (request *ModifyUserIPSWhitelistRequest) {
	request = &ModifyUserIPSWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyUserIPSWhitelist", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyUserIPSWhitelistResponse creates a response to parse from ModifyUserIPSWhitelist response
func CreateModifyUserIPSWhitelistResponse() (response *ModifyUserIPSWhitelistResponse) {
	response = &ModifyUserIPSWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
