package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAddressBook invokes the cloudfw.ModifyAddressBook API synchronously
func (client *Client) ModifyAddressBook(request *ModifyAddressBookRequest) (response *ModifyAddressBookResponse, err error) {
	response = CreateModifyAddressBookResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAddressBookWithChan invokes the cloudfw.ModifyAddressBook API asynchronously
func (client *Client) ModifyAddressBookWithChan(request *ModifyAddressBookRequest) (<-chan *ModifyAddressBookResponse, <-chan error) {
	responseChan := make(chan *ModifyAddressBookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAddressBook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAddressBookWithCallback invokes the cloudfw.ModifyAddressBook API asynchronously
func (client *Client) ModifyAddressBookWithCallback(request *ModifyAddressBookRequest, callback func(response *ModifyAddressBookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAddressBookResponse
		var err error
		defer close(result)
		response, err = client.ModifyAddressBook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAddressBookRequest is the request struct for api ModifyAddressBook
type ModifyAddressBookRequest struct {
	*requests.RpcRequest
	Description   string                      `position:"Query" name:"Description"`
	TagList       *[]ModifyAddressBookTagList `position:"Query" name:"TagList"  type:"Repeated"`
	GroupUuid     string                      `position:"Query" name:"GroupUuid"`
	SourceIp      string                      `position:"Query" name:"SourceIp"`
	AutoAddTagEcs string                      `position:"Query" name:"AutoAddTagEcs"`
	Lang          string                      `position:"Query" name:"Lang"`
	AddressList   string                      `position:"Query" name:"AddressList"`
	TagRelation   string                      `position:"Query" name:"TagRelation"`
	GroupName     string                      `position:"Query" name:"GroupName"`
}

// ModifyAddressBookTagList is a repeated param struct in ModifyAddressBookRequest
type ModifyAddressBookTagList struct {
	TagValue string `name:"TagValue"`
	TagKey   string `name:"TagKey"`
}

// ModifyAddressBookResponse is the response struct for api ModifyAddressBook
type ModifyAddressBookResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyAddressBookRequest creates a request to invoke ModifyAddressBook API
func CreateModifyAddressBookRequest() (request *ModifyAddressBookRequest) {
	request = &ModifyAddressBookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyAddressBook", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyAddressBookResponse creates a response to parse from ModifyAddressBook response
func CreateModifyAddressBookResponse() (response *ModifyAddressBookResponse) {
	response = &ModifyAddressBookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
