package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRiskEventGroup invokes the cloudfw.DescribeRiskEventGroup API synchronously
func (client *Client) DescribeRiskEventGroup(request *DescribeRiskEventGroupRequest) (response *DescribeRiskEventGroupResponse, err error) {
	response = CreateDescribeRiskEventGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRiskEventGroupWithChan invokes the cloudfw.DescribeRiskEventGroup API asynchronously
func (client *Client) DescribeRiskEventGroupWithChan(request *DescribeRiskEventGroupRequest) (<-chan *DescribeRiskEventGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeRiskEventGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRiskEventGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRiskEventGroupWithCallback invokes the cloudfw.DescribeRiskEventGroup API asynchronously
func (client *Client) DescribeRiskEventGroupWithCallback(request *DescribeRiskEventGroupRequest, callback func(response *DescribeRiskEventGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRiskEventGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeRiskEventGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRiskEventGroupRequest is the request struct for api DescribeRiskEventGroup
type DescribeRiskEventGroupRequest struct {
	*requests.RpcRequest
	SrcIP                string           `position:"Query" name:"SrcIP"`
	RuleResult           string           `position:"Query" name:"RuleResult"`
	RuleSource           string           `position:"Query" name:"RuleSource"`
	DstNetworkInstanceId string           `position:"Query" name:"DstNetworkInstanceId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	EventName            string           `position:"Query" name:"EventName"`
	SourceIp             string           `position:"Query" name:"SourceIp"`
	DataType             string           `position:"Query" name:"DataType"`
	BuyVersion           requests.Integer `position:"Query" name:"BuyVersion"`
	PageSize             string           `position:"Query" name:"PageSize"`
	DstIP                string           `position:"Query" name:"DstIP"`
	Lang                 string           `position:"Query" name:"Lang"`
	Direction            string           `position:"Query" name:"Direction"`
	FirewallType         string           `position:"Query" name:"FirewallType"`
	Order                string           `position:"Query" name:"Order"`
	VulLevel             string           `position:"Query" name:"VulLevel"`
	AttackType           string           `position:"Query" name:"AttackType"`
	SrcNetworkInstanceId string           `position:"Query" name:"SrcNetworkInstanceId"`
	EndTime              string           `position:"Query" name:"EndTime"`
	CurrentPage          string           `position:"Query" name:"CurrentPage"`
	Sort                 string           `position:"Query" name:"Sort"`
	AttackApp            *[]string        `position:"Query" name:"AttackApp"  type:"Repeated"`
	NoLocation           string           `position:"Query" name:"NoLocation"`
}

// DescribeRiskEventGroupResponse is the response struct for api DescribeRiskEventGroup
type DescribeRiskEventGroupResponse struct {
	*responses.BaseResponse
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DataList   []Data `json:"DataList" xml:"DataList"`
}

// CreateDescribeRiskEventGroupRequest creates a request to invoke DescribeRiskEventGroup API
func CreateDescribeRiskEventGroupRequest() (request *DescribeRiskEventGroupRequest) {
	request = &DescribeRiskEventGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeRiskEventGroup", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRiskEventGroupResponse creates a response to parse from DescribeRiskEventGroup response
func CreateDescribeRiskEventGroupResponse() (response *DescribeRiskEventGroupResponse) {
	response = &DescribeRiskEventGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
