package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAddressBook invokes the cloudfw.DeleteAddressBook API synchronously
func (client *Client) DeleteAddressBook(request *DeleteAddressBookRequest) (response *DeleteAddressBookResponse, err error) {
	response = CreateDeleteAddressBookResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAddressBookWithChan invokes the cloudfw.DeleteAddressBook API asynchronously
func (client *Client) DeleteAddressBookWithChan(request *DeleteAddressBookRequest) (<-chan *DeleteAddressBookResponse, <-chan error) {
	responseChan := make(chan *DeleteAddressBookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAddressBook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAddressBookWithCallback invokes the cloudfw.DeleteAddressBook API asynchronously
func (client *Client) DeleteAddressBookWithCallback(request *DeleteAddressBookRequest, callback func(response *DeleteAddressBookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAddressBookResponse
		var err error
		defer close(result)
		response, err = client.DeleteAddressBook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAddressBookRequest is the request struct for api DeleteAddressBook
type DeleteAddressBookRequest struct {
	*requests.RpcRequest
	GroupUuid string `position:"Query" name:"GroupUuid"`
	SourceIp  string `position:"Query" name:"SourceIp"`
	Lang      string `position:"Query" name:"Lang"`
}

// DeleteAddressBookResponse is the response struct for api DeleteAddressBook
type DeleteAddressBookResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAddressBookRequest creates a request to invoke DeleteAddressBook API
func CreateDeleteAddressBookRequest() (request *DeleteAddressBookRequest) {
	request = &DeleteAddressBookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DeleteAddressBook", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAddressBookResponse creates a response to parse from DeleteAddressBook response
func CreateDeleteAddressBookResponse() (response *DeleteAddressBookResponse) {
	response = &DeleteAddressBookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
