package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTrFirewallV2 invokes the cloudfw.CreateTrFirewallV2 API synchronously
func (client *Client) CreateTrFirewallV2(request *CreateTrFirewallV2Request) (response *CreateTrFirewallV2Response, err error) {
	response = CreateCreateTrFirewallV2Response()
	err = client.DoAction(request, response)
	return
}

// CreateTrFirewallV2WithChan invokes the cloudfw.CreateTrFirewallV2 API asynchronously
func (client *Client) CreateTrFirewallV2WithChan(request *CreateTrFirewallV2Request) (<-chan *CreateTrFirewallV2Response, <-chan error) {
	responseChan := make(chan *CreateTrFirewallV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTrFirewallV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTrFirewallV2WithCallback invokes the cloudfw.CreateTrFirewallV2 API asynchronously
func (client *Client) CreateTrFirewallV2WithCallback(request *CreateTrFirewallV2Request, callback func(response *CreateTrFirewallV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTrFirewallV2Response
		var err error
		defer close(result)
		response, err = client.CreateTrFirewallV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTrFirewallV2Request is the request struct for api CreateTrFirewallV2
type CreateTrFirewallV2Request struct {
	*requests.RpcRequest
	CenId                  string `position:"Query" name:"CenId"`
	SourceIp               string `position:"Query" name:"SourceIp"`
	FirewallVswitchId      string `position:"Query" name:"FirewallVswitchId"`
	Lang                   string `position:"Query" name:"Lang"`
	FirewallSubnetCidr     string `position:"Query" name:"FirewallSubnetCidr"`
	FirewallDescription    string `position:"Query" name:"FirewallDescription"`
	RouteMode              string `position:"Query" name:"RouteMode"`
	TrAttachmentMasterCidr string `position:"Query" name:"TrAttachmentMasterCidr"`
	FirewallVpcId          string `position:"Query" name:"FirewallVpcId"`
	FirewallName           string `position:"Query" name:"FirewallName"`
	TransitRouterId        string `position:"Query" name:"TransitRouterId"`
	FirewallVpcCidr        string `position:"Query" name:"FirewallVpcCidr"`
	RegionNo               string `position:"Query" name:"RegionNo"`
	TrAttachmentSlaveCidr  string `position:"Query" name:"TrAttachmentSlaveCidr"`
}

// CreateTrFirewallV2Response is the response struct for api CreateTrFirewallV2
type CreateTrFirewallV2Response struct {
	*responses.BaseResponse
	FirewallId string `json:"FirewallId" xml:"FirewallId"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTrFirewallV2Request creates a request to invoke CreateTrFirewallV2 API
func CreateCreateTrFirewallV2Request() (request *CreateTrFirewallV2Request) {
	request = &CreateTrFirewallV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "CreateTrFirewallV2", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTrFirewallV2Response creates a response to parse from CreateTrFirewallV2 response
func CreateCreateTrFirewallV2Response() (response *CreateTrFirewallV2Response) {
	response = &CreateTrFirewallV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
