package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Id2MetaVerify invokes the cloudauth.Id2MetaVerify API synchronously
func (client *Client) Id2MetaVerify(request *Id2MetaVerifyRequest) (response *Id2MetaVerifyResponse, err error) {
	response = CreateId2MetaVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// Id2MetaVerifyWithChan invokes the cloudauth.Id2MetaVerify API asynchronously
func (client *Client) Id2MetaVerifyWithChan(request *Id2MetaVerifyRequest) (<-chan *Id2MetaVerifyResponse, <-chan error) {
	responseChan := make(chan *Id2MetaVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Id2MetaVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Id2MetaVerifyWithCallback invokes the cloudauth.Id2MetaVerify API asynchronously
func (client *Client) Id2MetaVerifyWithCallback(request *Id2MetaVerifyRequest, callback func(response *Id2MetaVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Id2MetaVerifyResponse
		var err error
		defer close(result)
		response, err = client.Id2MetaVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Id2MetaVerifyRequest is the request struct for api Id2MetaVerify
type Id2MetaVerifyRequest struct {
	*requests.RpcRequest
	ParamType   string `position:"Query" name:"ParamType"`
	IdentifyNum string `position:"Query" name:"IdentifyNum"`
	UserName    string `position:"Query" name:"UserName"`
}

// Id2MetaVerifyResponse is the response struct for api Id2MetaVerify
type Id2MetaVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateId2MetaVerifyRequest creates a request to invoke Id2MetaVerify API
func CreateId2MetaVerifyRequest() (request *Id2MetaVerifyRequest) {
	request = &Id2MetaVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "Id2MetaVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateId2MetaVerifyResponse creates a response to parse from Id2MetaVerify response
func CreateId2MetaVerifyResponse() (response *Id2MetaVerifyResponse) {
	response = &Id2MetaVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
