package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceSlbConnect invokes the cloudapi.DescribeInstanceSlbConnect API synchronously
func (client *Client) DescribeInstanceSlbConnect(request *DescribeInstanceSlbConnectRequest) (response *DescribeInstanceSlbConnectResponse, err error) {
	response = CreateDescribeInstanceSlbConnectResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceSlbConnectWithChan invokes the cloudapi.DescribeInstanceSlbConnect API asynchronously
func (client *Client) DescribeInstanceSlbConnectWithChan(request *DescribeInstanceSlbConnectRequest) (<-chan *DescribeInstanceSlbConnectResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceSlbConnectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceSlbConnect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceSlbConnectWithCallback invokes the cloudapi.DescribeInstanceSlbConnect API asynchronously
func (client *Client) DescribeInstanceSlbConnectWithCallback(request *DescribeInstanceSlbConnectRequest, callback func(response *DescribeInstanceSlbConnectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceSlbConnectResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceSlbConnect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceSlbConnectRequest is the request struct for api DescribeInstanceSlbConnect
type DescribeInstanceSlbConnectRequest struct {
	*requests.RpcRequest
	EndTime       string `position:"Query" name:"EndTime"`
	StartTime     string `position:"Query" name:"StartTime"`
	SbcName       string `position:"Query" name:"SbcName"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeInstanceSlbConnectResponse is the response struct for api DescribeInstanceSlbConnect
type DescribeInstanceSlbConnectResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	InstanceSlbConnect InstanceSlbConnect `json:"InstanceSlbConnect" xml:"InstanceSlbConnect"`
}

// CreateDescribeInstanceSlbConnectRequest creates a request to invoke DescribeInstanceSlbConnect API
func CreateDescribeInstanceSlbConnectRequest() (request *DescribeInstanceSlbConnectRequest) {
	request = &DescribeInstanceSlbConnectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeInstanceSlbConnect", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceSlbConnectResponse creates a response to parse from DescribeInstanceSlbConnect response
func CreateDescribeInstanceSlbConnectResponse() (response *DescribeInstanceSlbConnectResponse) {
	response = &DescribeInstanceSlbConnectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
