package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAutomateResponseConfigStatus invokes the cloud_siem.UpdateAutomateResponseConfigStatus API synchronously
func (client *Client) UpdateAutomateResponseConfigStatus(request *UpdateAutomateResponseConfigStatusRequest) (response *UpdateAutomateResponseConfigStatusResponse, err error) {
	response = CreateUpdateAutomateResponseConfigStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAutomateResponseConfigStatusWithChan invokes the cloud_siem.UpdateAutomateResponseConfigStatus API asynchronously
func (client *Client) UpdateAutomateResponseConfigStatusWithChan(request *UpdateAutomateResponseConfigStatusRequest) (<-chan *UpdateAutomateResponseConfigStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateAutomateResponseConfigStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAutomateResponseConfigStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAutomateResponseConfigStatusWithCallback invokes the cloud_siem.UpdateAutomateResponseConfigStatus API asynchronously
func (client *Client) UpdateAutomateResponseConfigStatusWithCallback(request *UpdateAutomateResponseConfigStatusRequest, callback func(response *UpdateAutomateResponseConfigStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAutomateResponseConfigStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateAutomateResponseConfigStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAutomateResponseConfigStatusRequest is the request struct for api UpdateAutomateResponseConfigStatus
type UpdateAutomateResponseConfigStatusRequest struct {
	*requests.RpcRequest
	Ids   string           `position:"Body" name:"Ids"`
	InUse requests.Boolean `position:"Body" name:"InUse"`
}

// UpdateAutomateResponseConfigStatusResponse is the response struct for api UpdateAutomateResponseConfigStatus
type UpdateAutomateResponseConfigStatusResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateUpdateAutomateResponseConfigStatusRequest creates a request to invoke UpdateAutomateResponseConfigStatus API
func CreateUpdateAutomateResponseConfigStatusRequest() (request *UpdateAutomateResponseConfigStatusRequest) {
	request = &UpdateAutomateResponseConfigStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "UpdateAutomateResponseConfigStatus", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAutomateResponseConfigStatusResponse creates a response to parse from UpdateAutomateResponseConfigStatus response
func CreateUpdateAutomateResponseConfigStatusResponse() (response *UpdateAutomateResponseConfigStatusResponse) {
	response = &UpdateAutomateResponseConfigStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
