package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImportedLogCount invokes the cloud_siem.DescribeImportedLogCount API synchronously
func (client *Client) DescribeImportedLogCount(request *DescribeImportedLogCountRequest) (response *DescribeImportedLogCountResponse, err error) {
	response = CreateDescribeImportedLogCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImportedLogCountWithChan invokes the cloud_siem.DescribeImportedLogCount API asynchronously
func (client *Client) DescribeImportedLogCountWithChan(request *DescribeImportedLogCountRequest) (<-chan *DescribeImportedLogCountResponse, <-chan error) {
	responseChan := make(chan *DescribeImportedLogCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImportedLogCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImportedLogCountWithCallback invokes the cloud_siem.DescribeImportedLogCount API asynchronously
func (client *Client) DescribeImportedLogCountWithCallback(request *DescribeImportedLogCountRequest, callback func(response *DescribeImportedLogCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImportedLogCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeImportedLogCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImportedLogCountRequest is the request struct for api DescribeImportedLogCount
type DescribeImportedLogCountRequest struct {
	*requests.RpcRequest
}

// DescribeImportedLogCountResponse is the response struct for api DescribeImportedLogCount
type DescribeImportedLogCountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeImportedLogCountRequest creates a request to invoke DescribeImportedLogCount API
func CreateDescribeImportedLogCountRequest() (request *DescribeImportedLogCountRequest) {
	request = &DescribeImportedLogCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeImportedLogCount", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImportedLogCountResponse creates a response to parse from DescribeImportedLogCount response
func CreateDescribeImportedLogCountResponse() (response *DescribeImportedLogCountResponse) {
	response = &DescribeImportedLogCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
