package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransferVersion invokes the clickhouse.TransferVersion API synchronously
func (client *Client) TransferVersion(request *TransferVersionRequest) (response *TransferVersionResponse, err error) {
	response = CreateTransferVersionResponse()
	err = client.DoAction(request, response)
	return
}

// TransferVersionWithChan invokes the clickhouse.TransferVersion API asynchronously
func (client *Client) TransferVersionWithChan(request *TransferVersionRequest) (<-chan *TransferVersionResponse, <-chan error) {
	responseChan := make(chan *TransferVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransferVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransferVersionWithCallback invokes the clickhouse.TransferVersion API asynchronously
func (client *Client) TransferVersionWithCallback(request *TransferVersionRequest, callback func(response *TransferVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransferVersionResponse
		var err error
		defer close(result)
		response, err = client.TransferVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransferVersionRequest is the request struct for api TransferVersion
type TransferVersionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	SourceAccount        string           `position:"Query" name:"SourceAccount"`
	TargetAccount        string           `position:"Query" name:"TargetAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	SourcePassword       string           `position:"Query" name:"SourcePassword"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	TargetPassword       string           `position:"Query" name:"TargetPassword"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TargetDbClusterId    string           `position:"Query" name:"TargetDbClusterId"`
}

// TransferVersionResponse is the response struct for api TransferVersion
type TransferVersionResponse struct {
	*responses.BaseResponse
	DBInstanceID   int    `json:"DBInstanceID" xml:"DBInstanceID"`
	DBInstanceName int64  `json:"DBInstanceName" xml:"DBInstanceName"`
	TaskId         bool   `json:"TaskId" xml:"TaskId"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateTransferVersionRequest creates a request to invoke TransferVersion API
func CreateTransferVersionRequest() (request *TransferVersionRequest) {
	request = &TransferVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "TransferVersion", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTransferVersionResponse creates a response to parse from TransferVersion response
func CreateTransferVersionResponse() (response *TransferVersionResponse) {
	response = &TransferVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
