package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAccountAuthority invokes the clickhouse.ModifyAccountAuthority API synchronously
func (client *Client) ModifyAccountAuthority(request *ModifyAccountAuthorityRequest) (response *ModifyAccountAuthorityResponse, err error) {
	response = CreateModifyAccountAuthorityResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAccountAuthorityWithChan invokes the clickhouse.ModifyAccountAuthority API asynchronously
func (client *Client) ModifyAccountAuthorityWithChan(request *ModifyAccountAuthorityRequest) (<-chan *ModifyAccountAuthorityResponse, <-chan error) {
	responseChan := make(chan *ModifyAccountAuthorityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAccountAuthority(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAccountAuthorityWithCallback invokes the clickhouse.ModifyAccountAuthority API asynchronously
func (client *Client) ModifyAccountAuthorityWithCallback(request *ModifyAccountAuthorityRequest, callback func(response *ModifyAccountAuthorityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAccountAuthorityResponse
		var err error
		defer close(result)
		response, err = client.ModifyAccountAuthority(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAccountAuthorityRequest is the request struct for api ModifyAccountAuthority
type ModifyAccountAuthorityRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TotalDictionaries    string           `position:"Query" name:"TotalDictionaries"`
	AccountName          string           `position:"Query" name:"AccountName"`
	DmlAuthority         string           `position:"Query" name:"DmlAuthority"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	AllowDatabases       string           `position:"Query" name:"AllowDatabases"`
	AllowDictionaries    string           `position:"Query" name:"AllowDictionaries"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DdlAuthority         requests.Boolean `position:"Query" name:"DdlAuthority"`
	TotalDatabases       string           `position:"Query" name:"TotalDatabases"`
}

// ModifyAccountAuthorityResponse is the response struct for api ModifyAccountAuthority
type ModifyAccountAuthorityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyAccountAuthorityRequest creates a request to invoke ModifyAccountAuthority API
func CreateModifyAccountAuthorityRequest() (request *ModifyAccountAuthorityRequest) {
	request = &ModifyAccountAuthorityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "ModifyAccountAuthority", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyAccountAuthorityResponse creates a response to parse from ModifyAccountAuthority response
func CreateModifyAccountAuthorityResponse() (response *ModifyAccountAuthorityResponse) {
	response = &ModifyAccountAuthorityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
