package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAllDataSources invokes the clickhouse.DescribeAllDataSources API synchronously
func (client *Client) DescribeAllDataSources(request *DescribeAllDataSourcesRequest) (response *DescribeAllDataSourcesResponse, err error) {
	response = CreateDescribeAllDataSourcesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAllDataSourcesWithChan invokes the clickhouse.DescribeAllDataSources API asynchronously
func (client *Client) DescribeAllDataSourcesWithChan(request *DescribeAllDataSourcesRequest) (<-chan *DescribeAllDataSourcesResponse, <-chan error) {
	responseChan := make(chan *DescribeAllDataSourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAllDataSources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAllDataSourcesWithCallback invokes the clickhouse.DescribeAllDataSources API asynchronously
func (client *Client) DescribeAllDataSourcesWithCallback(request *DescribeAllDataSourcesRequest, callback func(response *DescribeAllDataSourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAllDataSourcesResponse
		var err error
		defer close(result)
		response, err = client.DescribeAllDataSources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAllDataSourcesRequest is the request struct for api DescribeAllDataSources
type DescribeAllDataSourcesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TableName            string           `position:"Query" name:"TableName"`
	SchemaName           string           `position:"Query" name:"SchemaName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeAllDataSourcesResponse is the response struct for api DescribeAllDataSources
type DescribeAllDataSourcesResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Tables    TablesInDescribeAllDataSources  `json:"Tables" xml:"Tables"`
	Columns   ColumnsInDescribeAllDataSources `json:"Columns" xml:"Columns"`
	Schemas   SchemasInDescribeAllDataSources `json:"Schemas" xml:"Schemas"`
}

// CreateDescribeAllDataSourcesRequest creates a request to invoke DescribeAllDataSources API
func CreateDescribeAllDataSourcesRequest() (request *DescribeAllDataSourcesRequest) {
	request = &DescribeAllDataSourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeAllDataSources", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAllDataSourcesResponse creates a response to parse from DescribeAllDataSources response
func CreateDescribeAllDataSourcesResponse() (response *DescribeAllDataSourcesResponse) {
	response = &DescribeAllDataSourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
