package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDevicePerson invokes the cdrs.ListDevicePerson API synchronously
func (client *Client) ListDevicePerson(request *ListDevicePersonRequest) (response *ListDevicePersonResponse, err error) {
	response = CreateListDevicePersonResponse()
	err = client.DoAction(request, response)
	return
}

// ListDevicePersonWithChan invokes the cdrs.ListDevicePerson API asynchronously
func (client *Client) ListDevicePersonWithChan(request *ListDevicePersonRequest) (<-chan *ListDevicePersonResponse, <-chan error) {
	responseChan := make(chan *ListDevicePersonResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDevicePerson(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDevicePersonWithCallback invokes the cdrs.ListDevicePerson API asynchronously
func (client *Client) ListDevicePersonWithCallback(request *ListDevicePersonRequest, callback func(response *ListDevicePersonResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDevicePersonResponse
		var err error
		defer close(result)
		response, err = client.ListDevicePerson(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDevicePersonRequest is the request struct for api ListDevicePerson
type ListDevicePersonRequest struct {
	*requests.RpcRequest
	StatisticsType string           `position:"Body" name:"StatisticsType"`
	CorpId         string           `position:"Body" name:"CorpId"`
	EndTime        string           `position:"Body" name:"EndTime"`
	StartTime      string           `position:"Body" name:"StartTime"`
	PageNumber     requests.Integer `position:"Body" name:"PageNumber"`
	DataSourceId   string           `position:"Body" name:"DataSourceId"`
	PageSize       requests.Integer `position:"Body" name:"PageSize"`
}

// ListDevicePersonResponse is the response struct for api ListDevicePerson
type ListDevicePersonResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListDevicePersonRequest creates a request to invoke ListDevicePerson API
func CreateListDevicePersonRequest() (request *ListDevicePersonRequest) {
	request = &ListDevicePersonRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListDevicePerson", "", "")
	request.Method = requests.POST
	return
}

// CreateListDevicePersonResponse creates a response to parse from ListDevicePerson response
func CreateListDevicePersonResponse() (response *ListDevicePersonResponse) {
	response = &ListDevicePersonResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
