package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDeleteCdnDomainConfig invokes the cdn.BatchDeleteCdnDomainConfig API synchronously
func (client *Client) BatchDeleteCdnDomainConfig(request *BatchDeleteCdnDomainConfigRequest) (response *BatchDeleteCdnDomainConfigResponse, err error) {
	response = CreateBatchDeleteCdnDomainConfigResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDeleteCdnDomainConfigWithChan invokes the cdn.BatchDeleteCdnDomainConfig API asynchronously
func (client *Client) BatchDeleteCdnDomainConfigWithChan(request *BatchDeleteCdnDomainConfigRequest) (<-chan *BatchDeleteCdnDomainConfigResponse, <-chan error) {
	responseChan := make(chan *BatchDeleteCdnDomainConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDeleteCdnDomainConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDeleteCdnDomainConfigWithCallback invokes the cdn.BatchDeleteCdnDomainConfig API asynchronously
func (client *Client) BatchDeleteCdnDomainConfigWithCallback(request *BatchDeleteCdnDomainConfigRequest, callback func(response *BatchDeleteCdnDomainConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDeleteCdnDomainConfigResponse
		var err error
		defer close(result)
		response, err = client.BatchDeleteCdnDomainConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDeleteCdnDomainConfigRequest is the request struct for api BatchDeleteCdnDomainConfig
type BatchDeleteCdnDomainConfigRequest struct {
	*requests.RpcRequest
	FunctionNames string           `position:"Query" name:"FunctionNames"`
	DomainNames   string           `position:"Query" name:"DomainNames"`
	OwnerAccount  string           `position:"Query" name:"OwnerAccount"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// BatchDeleteCdnDomainConfigResponse is the response struct for api BatchDeleteCdnDomainConfig
type BatchDeleteCdnDomainConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchDeleteCdnDomainConfigRequest creates a request to invoke BatchDeleteCdnDomainConfig API
func CreateBatchDeleteCdnDomainConfigRequest() (request *BatchDeleteCdnDomainConfigRequest) {
	request = &BatchDeleteCdnDomainConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "BatchDeleteCdnDomainConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchDeleteCdnDomainConfigResponse creates a response to parse from BatchDeleteCdnDomainConfig response
func CreateBatchDeleteCdnDomainConfigResponse() (response *BatchDeleteCdnDomainConfigResponse) {
	response = &BatchDeleteCdnDomainConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
