package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrivilegesOfUser invokes the ccc.ListPrivilegesOfUser API synchronously
func (client *Client) ListPrivilegesOfUser(request *ListPrivilegesOfUserRequest) (response *ListPrivilegesOfUserResponse, err error) {
	response = CreateListPrivilegesOfUserResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrivilegesOfUserWithChan invokes the ccc.ListPrivilegesOfUser API asynchronously
func (client *Client) ListPrivilegesOfUserWithChan(request *ListPrivilegesOfUserRequest) (<-chan *ListPrivilegesOfUserResponse, <-chan error) {
	responseChan := make(chan *ListPrivilegesOfUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrivilegesOfUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrivilegesOfUserWithCallback invokes the ccc.ListPrivilegesOfUser API asynchronously
func (client *Client) ListPrivilegesOfUserWithCallback(request *ListPrivilegesOfUserRequest, callback func(response *ListPrivilegesOfUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrivilegesOfUserResponse
		var err error
		defer close(result)
		response, err = client.ListPrivilegesOfUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrivilegesOfUserRequest is the request struct for api ListPrivilegesOfUser
type ListPrivilegesOfUserRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListPrivilegesOfUserResponse is the response struct for api ListPrivilegesOfUser
type ListPrivilegesOfUserResponse struct {
	*responses.BaseResponse
	Code           string     `json:"Code" xml:"Code"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string     `json:"Message" xml:"Message"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateListPrivilegesOfUserRequest creates a request to invoke ListPrivilegesOfUser API
func CreateListPrivilegesOfUserRequest() (request *ListPrivilegesOfUserRequest) {
	request = &ListPrivilegesOfUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListPrivilegesOfUser", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPrivilegesOfUserResponse creates a response to parse from ListPrivilegesOfUser response
func CreateListPrivilegesOfUserResponse() (response *ListPrivilegesOfUserResponse) {
	response = &ListPrivilegesOfUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
