package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLegacyAgentEventLogs invokes the ccc.ListLegacyAgentEventLogs API synchronously
func (client *Client) ListLegacyAgentEventLogs(request *ListLegacyAgentEventLogsRequest) (response *ListLegacyAgentEventLogsResponse, err error) {
	response = CreateListLegacyAgentEventLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListLegacyAgentEventLogsWithChan invokes the ccc.ListLegacyAgentEventLogs API asynchronously
func (client *Client) ListLegacyAgentEventLogsWithChan(request *ListLegacyAgentEventLogsRequest) (<-chan *ListLegacyAgentEventLogsResponse, <-chan error) {
	responseChan := make(chan *ListLegacyAgentEventLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLegacyAgentEventLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLegacyAgentEventLogsWithCallback invokes the ccc.ListLegacyAgentEventLogs API asynchronously
func (client *Client) ListLegacyAgentEventLogsWithCallback(request *ListLegacyAgentEventLogsRequest, callback func(response *ListLegacyAgentEventLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLegacyAgentEventLogsResponse
		var err error
		defer close(result)
		response, err = client.ListLegacyAgentEventLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLegacyAgentEventLogsRequest is the request struct for api ListLegacyAgentEventLogs
type ListLegacyAgentEventLogsRequest struct {
	*requests.RpcRequest
	AgentId    string           `position:"Query" name:"AgentId"`
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListLegacyAgentEventLogsResponse is the response struct for api ListLegacyAgentEventLogs
type ListLegacyAgentEventLogsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string                         `json:"Code" xml:"Code"`
	Message        string                         `json:"Message" xml:"Message"`
	RequestId      string                         `json:"RequestId" xml:"RequestId"`
	Success        bool                           `json:"Success" xml:"Success"`
	Data           DataInListLegacyAgentEventLogs `json:"Data" xml:"Data"`
}

// CreateListLegacyAgentEventLogsRequest creates a request to invoke ListLegacyAgentEventLogs API
func CreateListLegacyAgentEventLogsRequest() (request *ListLegacyAgentEventLogsRequest) {
	request = &ListLegacyAgentEventLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListLegacyAgentEventLogs", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLegacyAgentEventLogsResponse creates a response to parse from ListLegacyAgentEventLogs response
func CreateListLegacyAgentEventLogsResponse() (response *ListLegacyAgentEventLogsResponse) {
	response = &ListLegacyAgentEventLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
