package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLoginDetails invokes the ccc.GetLoginDetails API synchronously
func (client *Client) GetLoginDetails(request *GetLoginDetailsRequest) (response *GetLoginDetailsResponse, err error) {
	response = CreateGetLoginDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// GetLoginDetailsWithChan invokes the ccc.GetLoginDetails API asynchronously
func (client *Client) GetLoginDetailsWithChan(request *GetLoginDetailsRequest) (<-chan *GetLoginDetailsResponse, <-chan error) {
	responseChan := make(chan *GetLoginDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLoginDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLoginDetailsWithCallback invokes the ccc.GetLoginDetails API asynchronously
func (client *Client) GetLoginDetailsWithCallback(request *GetLoginDetailsRequest, callback func(response *GetLoginDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLoginDetailsResponse
		var err error
		defer close(result)
		response, err = client.GetLoginDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLoginDetailsRequest is the request struct for api GetLoginDetails
type GetLoginDetailsRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetLoginDetailsResponse is the response struct for api GetLoginDetails
type GetLoginDetailsResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateGetLoginDetailsRequest creates a request to invoke GetLoginDetails API
func CreateGetLoginDetailsRequest() (request *GetLoginDetailsRequest) {
	request = &GetLoginDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetLoginDetails", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLoginDetailsResponse creates a response to parse from GetLoginDetails response
func CreateGetLoginDetailsResponse() (response *GetLoginDetailsResponse) {
	response = &GetLoginDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
