package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeWorkMode invokes the ccc.ChangeWorkMode API synchronously
func (client *Client) ChangeWorkMode(request *ChangeWorkModeRequest) (response *ChangeWorkModeResponse, err error) {
	response = CreateChangeWorkModeResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeWorkModeWithChan invokes the ccc.ChangeWorkMode API asynchronously
func (client *Client) ChangeWorkModeWithChan(request *ChangeWorkModeRequest) (<-chan *ChangeWorkModeResponse, <-chan error) {
	responseChan := make(chan *ChangeWorkModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeWorkMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeWorkModeWithCallback invokes the ccc.ChangeWorkMode API asynchronously
func (client *Client) ChangeWorkModeWithCallback(request *ChangeWorkModeRequest, callback func(response *ChangeWorkModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeWorkModeResponse
		var err error
		defer close(result)
		response, err = client.ChangeWorkMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeWorkModeRequest is the request struct for api ChangeWorkMode
type ChangeWorkModeRequest struct {
	*requests.RpcRequest
	SignedSkillGroupIdList string `position:"Query" name:"SignedSkillGroupIdList"`
	Mobile                 string `position:"Query" name:"Mobile"`
	WorkMode               string `position:"Query" name:"WorkMode"`
	UserId                 string `position:"Query" name:"UserId"`
	DeviceId               string `position:"Query" name:"DeviceId"`
	InstanceId             string `position:"Query" name:"InstanceId"`
}

// ChangeWorkModeResponse is the response struct for api ChangeWorkMode
type ChangeWorkModeResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateChangeWorkModeRequest creates a request to invoke ChangeWorkMode API
func CreateChangeWorkModeRequest() (request *ChangeWorkModeRequest) {
	request = &ChangeWorkModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ChangeWorkMode", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateChangeWorkModeResponse creates a response to parse from ChangeWorkMode response
func CreateChangeWorkModeResponse() (response *ChangeWorkModeResponse) {
	response = &ChangeWorkModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
