package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AppendCases invokes the ccc.AppendCases API synchronously
func (client *Client) AppendCases(request *AppendCasesRequest) (response *AppendCasesResponse, err error) {
	response = CreateAppendCasesResponse()
	err = client.DoAction(request, response)
	return
}

// AppendCasesWithChan invokes the ccc.AppendCases API asynchronously
func (client *Client) AppendCasesWithChan(request *AppendCasesRequest) (<-chan *AppendCasesResponse, <-chan error) {
	responseChan := make(chan *AppendCasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AppendCases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AppendCasesWithCallback invokes the ccc.AppendCases API asynchronously
func (client *Client) AppendCasesWithCallback(request *AppendCasesRequest, callback func(response *AppendCasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AppendCasesResponse
		var err error
		defer close(result)
		response, err = client.AppendCases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AppendCasesRequest is the request struct for api AppendCases
type AppendCasesRequest struct {
	*requests.RpcRequest
	InstanceId string             `position:"Query" name:"InstanceId"`
	CampaignId string             `position:"Query" name:"CampaignId"`
	Body       *[]AppendCasesBody `position:"Body" name:"body"  type:"Json"`
}

// AppendCasesBody is a repeated param struct in AppendCasesRequest
type AppendCasesBody struct {
	CustomVariables string `name:"CustomVariables"`
	Caller          string `name:"Caller"`
	AgentId         string `name:"AgentId"`
	PhoneNumber     string `name:"PhoneNumber"`
	MaskedCallee    string `name:"MaskedCallee"`
	ReferenceId     string `name:"ReferenceId"`
}

// AppendCasesResponse is the response struct for api AppendCases
type AppendCasesResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateAppendCasesRequest creates a request to invoke AppendCases API
func CreateAppendCasesRequest() (request *AppendCasesRequest) {
	request = &AppendCasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "AppendCases", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAppendCasesResponse creates a response to parse from AppendCases response
func CreateAppendCasesResponse() (response *AppendCasesResponse) {
	response = &AppendCasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
