package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransitRouterPrefixListAssociation invokes the cbn.ListTransitRouterPrefixListAssociation API synchronously
func (client *Client) ListTransitRouterPrefixListAssociation(request *ListTransitRouterPrefixListAssociationRequest) (response *ListTransitRouterPrefixListAssociationResponse, err error) {
	response = CreateListTransitRouterPrefixListAssociationResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransitRouterPrefixListAssociationWithChan invokes the cbn.ListTransitRouterPrefixListAssociation API asynchronously
func (client *Client) ListTransitRouterPrefixListAssociationWithChan(request *ListTransitRouterPrefixListAssociationRequest) (<-chan *ListTransitRouterPrefixListAssociationResponse, <-chan error) {
	responseChan := make(chan *ListTransitRouterPrefixListAssociationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransitRouterPrefixListAssociation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransitRouterPrefixListAssociationWithCallback invokes the cbn.ListTransitRouterPrefixListAssociation API asynchronously
func (client *Client) ListTransitRouterPrefixListAssociationWithCallback(request *ListTransitRouterPrefixListAssociationRequest, callback func(response *ListTransitRouterPrefixListAssociationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransitRouterPrefixListAssociationResponse
		var err error
		defer close(result)
		response, err = client.ListTransitRouterPrefixListAssociation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransitRouterPrefixListAssociationRequest is the request struct for api ListTransitRouterPrefixListAssociation
type ListTransitRouterPrefixListAssociationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	NextHopInstanceId    string           `position:"Query" name:"NextHopInstanceId"`
	PrefixListId         string           `position:"Query" name:"PrefixListId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	OwnerUid             requests.Integer `position:"Query" name:"OwnerUid"`
	NextHopType          string           `position:"Query" name:"NextHopType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterId      string           `position:"Query" name:"TransitRouterId"`
	TransitRouterTableId string           `position:"Query" name:"TransitRouterTableId"`
	Version              string           `position:"Query" name:"Version"`
	NextHop              string           `position:"Query" name:"NextHop"`
	Status               string           `position:"Query" name:"Status"`
}

// ListTransitRouterPrefixListAssociationResponse is the response struct for api ListTransitRouterPrefixListAssociation
type ListTransitRouterPrefixListAssociationResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	TotalCount  int          `json:"TotalCount" xml:"TotalCount"`
	PageSize    int          `json:"PageSize" xml:"PageSize"`
	PageNumber  int          `json:"PageNumber" xml:"PageNumber"`
	PrefixLists []PrefixList `json:"PrefixLists" xml:"PrefixLists"`
}

// CreateListTransitRouterPrefixListAssociationRequest creates a request to invoke ListTransitRouterPrefixListAssociation API
func CreateListTransitRouterPrefixListAssociationRequest() (request *ListTransitRouterPrefixListAssociationRequest) {
	request = &ListTransitRouterPrefixListAssociationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTransitRouterPrefixListAssociation", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTransitRouterPrefixListAssociationResponse creates a response to parse from ListTransitRouterPrefixListAssociation response
func CreateListTransitRouterPrefixListAssociationResponse() (response *ListTransitRouterPrefixListAssociationResponse) {
	response = &ListTransitRouterPrefixListAssociationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
