package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCenInterRegionTrafficQosQueue invokes the cbn.CreateCenInterRegionTrafficQosQueue API synchronously
func (client *Client) CreateCenInterRegionTrafficQosQueue(request *CreateCenInterRegionTrafficQosQueueRequest) (response *CreateCenInterRegionTrafficQosQueueResponse, err error) {
	response = CreateCreateCenInterRegionTrafficQosQueueResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCenInterRegionTrafficQosQueueWithChan invokes the cbn.CreateCenInterRegionTrafficQosQueue API asynchronously
func (client *Client) CreateCenInterRegionTrafficQosQueueWithChan(request *CreateCenInterRegionTrafficQosQueueRequest) (<-chan *CreateCenInterRegionTrafficQosQueueResponse, <-chan error) {
	responseChan := make(chan *CreateCenInterRegionTrafficQosQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCenInterRegionTrafficQosQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCenInterRegionTrafficQosQueueWithCallback invokes the cbn.CreateCenInterRegionTrafficQosQueue API asynchronously
func (client *Client) CreateCenInterRegionTrafficQosQueueWithCallback(request *CreateCenInterRegionTrafficQosQueueRequest, callback func(response *CreateCenInterRegionTrafficQosQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCenInterRegionTrafficQosQueueResponse
		var err error
		defer close(result)
		response, err = client.CreateCenInterRegionTrafficQosQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCenInterRegionTrafficQosQueueRequest is the request struct for api CreateCenInterRegionTrafficQosQueue
type CreateCenInterRegionTrafficQosQueueRequest struct {
	*requests.RpcRequest
	Dscps                  *[]string        `position:"Query" name:"Dscps"  type:"Repeated"`
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string           `position:"Query" name:"ClientToken"`
	QosQueueName           string           `position:"Query" name:"QosQueueName"`
	RemainBandwidthPercent string           `position:"Query" name:"RemainBandwidthPercent"`
	DryRun                 requests.Boolean `position:"Query" name:"DryRun"`
	TrafficQosPolicyId     string           `position:"Query" name:"TrafficQosPolicyId"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	Version                string           `position:"Query" name:"Version"`
	QosQueueDescription    string           `position:"Query" name:"QosQueueDescription"`
}

// CreateCenInterRegionTrafficQosQueueResponse is the response struct for api CreateCenInterRegionTrafficQosQueue
type CreateCenInterRegionTrafficQosQueueResponse struct {
	*responses.BaseResponse
	QosQueueId string `json:"QosQueueId" xml:"QosQueueId"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCenInterRegionTrafficQosQueueRequest creates a request to invoke CreateCenInterRegionTrafficQosQueue API
func CreateCreateCenInterRegionTrafficQosQueueRequest() (request *CreateCenInterRegionTrafficQosQueueRequest) {
	request = &CreateCenInterRegionTrafficQosQueueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateCenInterRegionTrafficQosQueue", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCenInterRegionTrafficQosQueueResponse creates a response to parse from CreateCenInterRegionTrafficQosQueue response
func CreateCreateCenInterRegionTrafficQosQueueResponse() (response *CreateCenInterRegionTrafficQosQueueResponse) {
	response = &CreateCenInterRegionTrafficQosQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
