package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryResellerUserAlarmThreshold invokes the bssopenapi.QueryResellerUserAlarmThreshold API synchronously
func (client *Client) QueryResellerUserAlarmThreshold(request *QueryResellerUserAlarmThresholdRequest) (response *QueryResellerUserAlarmThresholdResponse, err error) {
	response = CreateQueryResellerUserAlarmThresholdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryResellerUserAlarmThresholdWithChan invokes the bssopenapi.QueryResellerUserAlarmThreshold API asynchronously
func (client *Client) QueryResellerUserAlarmThresholdWithChan(request *QueryResellerUserAlarmThresholdRequest) (<-chan *QueryResellerUserAlarmThresholdResponse, <-chan error) {
	responseChan := make(chan *QueryResellerUserAlarmThresholdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryResellerUserAlarmThreshold(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryResellerUserAlarmThresholdWithCallback invokes the bssopenapi.QueryResellerUserAlarmThreshold API asynchronously
func (client *Client) QueryResellerUserAlarmThresholdWithCallback(request *QueryResellerUserAlarmThresholdRequest, callback func(response *QueryResellerUserAlarmThresholdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryResellerUserAlarmThresholdResponse
		var err error
		defer close(result)
		response, err = client.QueryResellerUserAlarmThreshold(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryResellerUserAlarmThresholdRequest is the request struct for api QueryResellerUserAlarmThreshold
type QueryResellerUserAlarmThresholdRequest struct {
	*requests.RpcRequest
	AlarmType string           `position:"Query" name:"AlarmType"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryResellerUserAlarmThresholdResponse is the response struct for api QueryResellerUserAlarmThreshold
type QueryResellerUserAlarmThresholdResponse struct {
	*responses.BaseResponse
	Count     int        `json:"Count" xml:"Count"`
	Success   bool       `json:"Success" xml:"Success"`
	Code      string     `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryResellerUserAlarmThresholdRequest creates a request to invoke QueryResellerUserAlarmThreshold API
func CreateQueryResellerUserAlarmThresholdRequest() (request *QueryResellerUserAlarmThresholdRequest) {
	request = &QueryResellerUserAlarmThresholdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryResellerUserAlarmThreshold", "bssopenapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryResellerUserAlarmThresholdResponse creates a response to parse from QueryResellerUserAlarmThreshold response
func CreateQueryResellerUserAlarmThresholdResponse() (response *QueryResellerUserAlarmThresholdResponse) {
	response = &QueryResellerUserAlarmThresholdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
