package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAccountTransactionDetails invokes the bssopenapi.QueryAccountTransactionDetails API synchronously
func (client *Client) QueryAccountTransactionDetails(request *QueryAccountTransactionDetailsRequest) (response *QueryAccountTransactionDetailsResponse, err error) {
	response = CreateQueryAccountTransactionDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAccountTransactionDetailsWithChan invokes the bssopenapi.QueryAccountTransactionDetails API asynchronously
func (client *Client) QueryAccountTransactionDetailsWithChan(request *QueryAccountTransactionDetailsRequest) (<-chan *QueryAccountTransactionDetailsResponse, <-chan error) {
	responseChan := make(chan *QueryAccountTransactionDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAccountTransactionDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAccountTransactionDetailsWithCallback invokes the bssopenapi.QueryAccountTransactionDetails API asynchronously
func (client *Client) QueryAccountTransactionDetailsWithCallback(request *QueryAccountTransactionDetailsRequest, callback func(response *QueryAccountTransactionDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAccountTransactionDetailsResponse
		var err error
		defer close(result)
		response, err = client.QueryAccountTransactionDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAccountTransactionDetailsRequest is the request struct for api QueryAccountTransactionDetails
type QueryAccountTransactionDetailsRequest struct {
	*requests.RpcRequest
	TransactionType      string           `position:"Query" name:"TransactionType"`
	CreateTimeEnd        string           `position:"Query" name:"CreateTimeEnd"`
	RecordID             string           `position:"Query" name:"RecordID"`
	NextToken            string           `position:"Query" name:"NextToken"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
	TransactionChannel   string           `position:"Query" name:"TransactionChannel"`
	TransactionChannelSN string           `position:"Query" name:"TransactionChannelSN"`
	CreateTimeStart      string           `position:"Query" name:"CreateTimeStart"`
	TransactionNumber    string           `position:"Query" name:"TransactionNumber"`
}

// QueryAccountTransactionDetailsResponse is the response struct for api QueryAccountTransactionDetails
type QueryAccountTransactionDetailsResponse struct {
	*responses.BaseResponse
	Code      string                               `json:"Code" xml:"Code"`
	Message   string                               `json:"Message" xml:"Message"`
	RequestId string                               `json:"RequestId" xml:"RequestId"`
	Success   bool                                 `json:"Success" xml:"Success"`
	Data      DataInQueryAccountTransactionDetails `json:"Data" xml:"Data"`
}

// CreateQueryAccountTransactionDetailsRequest creates a request to invoke QueryAccountTransactionDetails API
func CreateQueryAccountTransactionDetailsRequest() (request *QueryAccountTransactionDetailsRequest) {
	request = &QueryAccountTransactionDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryAccountTransactionDetails", "bssopenapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryAccountTransactionDetailsResponse creates a response to parse from QueryAccountTransactionDetails response
func CreateQueryAccountTransactionDetailsResponse() (response *QueryAccountTransactionDetailsResponse) {
	response = &QueryAccountTransactionDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
