package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendCommand invokes the avatar.SendCommand API synchronously
func (client *Client) SendCommand(request *SendCommandRequest) (response *SendCommandResponse, err error) {
	response = CreateSendCommandResponse()
	err = client.DoAction(request, response)
	return
}

// SendCommandWithChan invokes the avatar.SendCommand API asynchronously
func (client *Client) SendCommandWithChan(request *SendCommandRequest) (<-chan *SendCommandResponse, <-chan error) {
	responseChan := make(chan *SendCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendCommandWithCallback invokes the avatar.SendCommand API asynchronously
func (client *Client) SendCommandWithCallback(request *SendCommandRequest, callback func(response *SendCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendCommandResponse
		var err error
		defer close(result)
		response, err = client.SendCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendCommandRequest is the request struct for api SendCommand
type SendCommandRequest struct {
	*requests.RpcRequest
	Feedback   requests.Boolean  `position:"Query" name:"Feedback"`
	Code       string            `position:"Query" name:"Code"`
	UniqueCode string            `position:"Query" name:"UniqueCode"`
	TenantId   requests.Integer  `position:"Query" name:"TenantId"`
	SessionId  string            `position:"Query" name:"SessionId"`
	Content    map[string]string `position:"Query" name:"Content"  type:"Map"`
}

// SendCommandResponse is the response struct for api SendCommand
type SendCommandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSendCommandRequest creates a request to invoke SendCommand API
func CreateSendCommandRequest() (request *SendCommandRequest) {
	request = &SendCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "SendCommand", "", "")
	request.Method = requests.POST
	return
}

// CreateSendCommandResponse creates a response to parse from SendCommand response
func CreateSendCommandResponse() (response *SendCommandResponse) {
	response = &SendCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
