package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAvatar invokes the avatar.QueryAvatar API synchronously
func (client *Client) QueryAvatar(request *QueryAvatarRequest) (response *QueryAvatarResponse, err error) {
	response = CreateQueryAvatarResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAvatarWithChan invokes the avatar.QueryAvatar API asynchronously
func (client *Client) QueryAvatarWithChan(request *QueryAvatarRequest) (<-chan *QueryAvatarResponse, <-chan error) {
	responseChan := make(chan *QueryAvatarResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAvatar(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAvatarWithCallback invokes the avatar.QueryAvatar API asynchronously
func (client *Client) QueryAvatarWithCallback(request *QueryAvatarRequest, callback func(response *QueryAvatarResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAvatarResponse
		var err error
		defer close(result)
		response, err = client.QueryAvatar(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAvatarRequest is the request struct for api QueryAvatar
type QueryAvatarRequest struct {
	*requests.RpcRequest
	Code         string           `position:"Query" name:"Code"`
	TenantId     requests.Integer `position:"Query" name:"TenantId"`
	ExtParamsCLS string           `position:"Query" name:"ExtParams_CLS"`
	ExtParams    string           `position:"Query" name:"ExtParams"`
}

// QueryAvatarResponse is the response struct for api QueryAvatar
type QueryAvatarResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryAvatarRequest creates a request to invoke QueryAvatar API
func CreateQueryAvatarRequest() (request *QueryAvatarRequest) {
	request = &QueryAvatarRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "QueryAvatar", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryAvatarResponse creates a response to parse from QueryAvatar response
func CreateQueryAvatarResponse() (response *QueryAvatarResponse) {
	response = &QueryAvatarResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
