package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrometheusMonitoring invokes the arms.ListPrometheusMonitoring API synchronously
func (client *Client) ListPrometheusMonitoring(request *ListPrometheusMonitoringRequest) (response *ListPrometheusMonitoringResponse, err error) {
	response = CreateListPrometheusMonitoringResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrometheusMonitoringWithChan invokes the arms.ListPrometheusMonitoring API asynchronously
func (client *Client) ListPrometheusMonitoringWithChan(request *ListPrometheusMonitoringRequest) (<-chan *ListPrometheusMonitoringResponse, <-chan error) {
	responseChan := make(chan *ListPrometheusMonitoringResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrometheusMonitoring(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrometheusMonitoringWithCallback invokes the arms.ListPrometheusMonitoring API asynchronously
func (client *Client) ListPrometheusMonitoringWithCallback(request *ListPrometheusMonitoringRequest, callback func(response *ListPrometheusMonitoringResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrometheusMonitoringResponse
		var err error
		defer close(result)
		response, err = client.ListPrometheusMonitoring(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrometheusMonitoringRequest is the request struct for api ListPrometheusMonitoring
type ListPrometheusMonitoringRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
	Type      string `position:"Query" name:"Type"`
}

// ListPrometheusMonitoringResponse is the response struct for api ListPrometheusMonitoring
type ListPrometheusMonitoringResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Code      int          `json:"Code" xml:"Code"`
	Message   string       `json:"Message" xml:"Message"`
	Data      []Monitoring `json:"Data" xml:"Data"`
}

// CreateListPrometheusMonitoringRequest creates a request to invoke ListPrometheusMonitoring API
func CreateListPrometheusMonitoringRequest() (request *ListPrometheusMonitoringRequest) {
	request = &ListPrometheusMonitoringRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListPrometheusMonitoring", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPrometheusMonitoringResponse creates a response to parse from ListPrometheusMonitoring response
func CreateListPrometheusMonitoringResponse() (response *ListPrometheusMonitoringResponse) {
	response = &ListPrometheusMonitoringResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
