package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrUpdateSilencePolicy invokes the arms.CreateOrUpdateSilencePolicy API synchronously
func (client *Client) CreateOrUpdateSilencePolicy(request *CreateOrUpdateSilencePolicyRequest) (response *CreateOrUpdateSilencePolicyResponse, err error) {
	response = CreateCreateOrUpdateSilencePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrUpdateSilencePolicyWithChan invokes the arms.CreateOrUpdateSilencePolicy API asynchronously
func (client *Client) CreateOrUpdateSilencePolicyWithChan(request *CreateOrUpdateSilencePolicyRequest) (<-chan *CreateOrUpdateSilencePolicyResponse, <-chan error) {
	responseChan := make(chan *CreateOrUpdateSilencePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrUpdateSilencePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrUpdateSilencePolicyWithCallback invokes the arms.CreateOrUpdateSilencePolicy API asynchronously
func (client *Client) CreateOrUpdateSilencePolicyWithCallback(request *CreateOrUpdateSilencePolicyRequest, callback func(response *CreateOrUpdateSilencePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrUpdateSilencePolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateOrUpdateSilencePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrUpdateSilencePolicyRequest is the request struct for api CreateOrUpdateSilencePolicy
type CreateOrUpdateSilencePolicyRequest struct {
	*requests.RpcRequest
	Name          string           `position:"Body" name:"Name"`
	Id            requests.Integer `position:"Body" name:"Id"`
	ProxyUserId   string           `position:"Body" name:"ProxyUserId"`
	MatchingRules string           `position:"Body" name:"MatchingRules"`
	AreaCodes     string           `position:"Body" name:"AreaCodes"`
}

// CreateOrUpdateSilencePolicyResponse is the response struct for api CreateOrUpdateSilencePolicy
type CreateOrUpdateSilencePolicyResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	SilencePolicy SilencePolicy `json:"SilencePolicy" xml:"SilencePolicy"`
}

// CreateCreateOrUpdateSilencePolicyRequest creates a request to invoke CreateOrUpdateSilencePolicy API
func CreateCreateOrUpdateSilencePolicyRequest() (request *CreateOrUpdateSilencePolicyRequest) {
	request = &CreateOrUpdateSilencePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "CreateOrUpdateSilencePolicy", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOrUpdateSilencePolicyResponse creates a response to parse from CreateOrUpdateSilencePolicy response
func CreateCreateOrUpdateSilencePolicyResponse() (response *CreateOrUpdateSilencePolicyResponse) {
	response = &CreateOrUpdateSilencePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
